% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QSOrder.R
\name{QSOrder}
\alias{QSOrder}
\title{Quasi Sequence Order}
\usage{
QSOrder(seqs, nlag = 25, W = 0.1, label = c())
}
\arguments{
\item{seqs}{is a FASTA file with amino acid sequences. Each sequence starts
with a '>' character. Also, seqs could be a string vector. Each element of the vector is a peptide/protein sequence.}

\item{nlag}{is a numeric value which shows the maximum distance between two amino acids.
Distances can be 1, 2, ..., or nlag.}

\item{W}{(weight) is a tuning parameter.}

\item{label}{is an optional parameter. It is a vector whose length is equivalent to the number of sequences. It shows the class of
each entry (i.e., sequence).}
}
\value{
It returns a feature matrix which the number of rows equals to the number of sequences and the number of columns is (nlag*2).
For each distance d, there are two values. One value for Granthman and another one for Schneider distance.
}
\description{
This function computes the quasi-sequence-order for sequences.
It is for amino acid pairs with d distances (d can be any number between 1 and 20).
First, it calculates the frequencies of each amino acid ("A", "C",..., "Y").
Then, it normalizes the frequencies by dividing the frequency of an amino acid to the frequency of all amino acids
plus the sum of tau values which is multiplied by W. tau values are given by function \link{SOCNumber}.
For d bigger than 20, it computes tau for d in the range "1 to (nlag-20) * W" and normalizes them like before.
}
\details{
Please find details about tau in function \link{SOCNumber}.
}
\note{
For d between 21 to nlag, the function calculates tau values for (d-20) to (nlag-20).
}
\examples{

filePrs<-system.file("extdata/proteins.fasta",package="ftrCOOL")

mat<-QSOrder(seqs=filePrs,nlag=25)

}
