% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kAAComposition.R
\name{kAAComposition}
\alias{kAAComposition}
\title{K Amino Acid Composition}
\usage{
kAAComposition(seqs, rng = 3, upto = FALSE, normalized = TRUE, label = c())
}
\arguments{
\item{seqs}{is a FASTA file with amino acid sequences. Each sequence starts
with a '>' character. Also, seqs could be a string vector. Each element of the vector is a peptide/protein sequence.}

\item{rng}{This parameter can be a number or a vector. Each entry of the vector holds the value of k in the k-mer composition.}

\item{upto}{It is a logical parameter. The default value is FALSE. If rng is a number and upto is set to TRUE, rng is converted
to a vector with values from 1 to rng.}

\item{normalized}{is a logical parameter. When it is FALSE, the return value of the function does not change. Otherwise, the return value is normalized using the length of the sequence.}

\item{label}{is an optional parameter. It is a vector whose length is equivalent to the number of sequences. It shows the class of
each entry (i.e., sequence).}
}
\value{
This function returns a feature matrix. The number of rows is equal to the number of sequences and
the number of columns depends on rng vector. For each value k in the vector, (20)^k columns are created in the matrix.
}
\description{
This function calculates the frequency of all k-mers in the sequence(s).
}
\examples{

filePrs<-system.file("extdata/proteins.fasta",package="ftrCOOL")

mat1<-kAAComposition(seqs=filePrs,rng=3,upto=TRUE)
mat2<-kAAComposition(seqs=filePrs,rng=c(1,3),upto=TRUE)
}
