% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DiNUCindex_DNA.R
\name{DiNUCindex_DNA}
\alias{DiNUCindex_DNA}
\title{Di Nucleotide Index (DiNUCindex_DNA)}
\usage{
DiNUCindex_DNA(
  seqs,
  selectedIdx = c("Rise", "Roll", "Shift", "Slide", "Tilt", "Twist"),
  threshold = 1,
  label = c(),
  outFormat = "mat",
  outputFileDist = ""
)
}
\arguments{
\item{seqs}{is a FASTA file containing nucleotide sequences. The sequences start
with '>'. Also, seqs could be a string vector. Each element of the vector is a nucleotide sequence.}

\item{selectedIdx}{DiNUCindex_DNA function works based on physicochemical properties. Users, select the properties by their ids
or indexes in DI_DNA index file.
The default value of this parameter is a vector with ("Rise", "Roll", "Shift", "Slide", "Tilt", "Twist") entries.}

\item{threshold}{is a number between (0 , 1]. In selectedAAidx, indices with a correlation
higher than the threshold will be deleted. The default value is 1.}

\item{label}{is an optional parameter. It is a vector whose length is equivalent to the number of sequences. It shows the class of
each entry (i.e., sequence).}

\item{outFormat}{(output format) can take two values: 'mat'(matrix) and 'txt'. The default value is 'mat'.}

\item{outputFileDist}{shows the path and name of the 'txt' output file.}
}
\value{
The output depends on the outFormat parameter which can be either 'mat' or 'txt'. If outFormat is 'mat', the function returns a feature
matrix for sequences with the same length such that the number of columns is (sequence length-1)*(number of selected di-nucleotide indexes)
and the number of rows is equal to the number of sequences.
If the outFormat is 'txt', the output is written to a tab-delimited file.
}
\description{
This function replaces dinucleotides in a sequence with their physicochemical properties in the dinucleotide index file.
}
\details{
There are 148 physicochemical indexes in the dinucleotide database.
}
\note{
This function is provided for sequences with the same lengths.
Users can use 'txt' option in outFormat for sequences with different lengths.
Warning: If outFormat is set to 'mat' for sequences with different lengths, it returns an error.
Also, when output format is 'txt', label information is not shown in the text file.
It is noteworthy that 'txt' format is not usable for machine learning purposes if sequences have different sizes. Otherwise 'txt' format
is also usable for machine learning purposes.
}
\examples{

fileLNC<-system.file("extdata/Athaliana1.fa",package="ftrCOOL")
vect<-DiNUCindex_DNA(seqs = fileLNC,outFormat="mat")
}
