% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KNNProtein.R
\name{KNNProtein}
\alias{KNNProtein}
\title{K-Nearest Neighbor for Protein (KNNProtein)}
\usage{
KNNProtein(seqs, trainSeq, percent = 30, labeltr = c(), label = c())
}
\arguments{
\item{seqs}{is a fasta file with amino acids sequences. Each sequence starts
with a '>' character. Also it could be a string vector such that each element is a protein sequence.}

\item{trainSeq}{is a fasta file with amino acids sequences. Each sequence starts
with a '>' character. Also it could be a string vector such that each element is a protein sequence. Eaxh sequence in the training set
is associated with a label. The label is found in the parameret labeltr.}

\item{percent}{determines the threshold which is used to identify sequences (in the training set) which are similar to the input sequence.}

\item{labeltr}{This parameter is a vector whose length is equivalent to the number of sequences in the training set. It shows class of
each sequence in the trainig set.}

\item{label}{is an optional parameter. It is a vector whose length is equivalent to the number of sequences. It shows the class of
each entry (i.e., sequence).}
}
\value{
This function returns a feature matrix such that number of columns is number of classes multiplied by percent and number of rows is equal to the number of the sequences.
}
\description{
This function is like \link{KNNPeptide} with the difference that similarity score is computed by Needleman-Wunsch algorithm.
}
\examples{

ptmSeqsADR<-system.file("extdata/",package="ftrCOOL")
ptmSeqsVect<-as.vector(read.csv(paste0(ptmSeqsADR,"/ptmVect101AA.csv"))[,2])
ptmSeqsVect<-ptmSeqsVect[1:2]

posSeqs<-as.vector(read.csv(paste0(ptmSeqsADR,"/poSeqPTM101.csv"))[,2])
negSeqs<-as.vector(read.csv(paste0(ptmSeqsADR,"/negSeqPTM101.csv"))[,2])

posSeqs<-posSeqs[1:3]
negSeqs<-negSeqs[1:3]

trainSeq<-c(posSeqs,negSeqs)

labelPos<-rep(1,length(posSeqs))
labelNeg<-rep(0,length(negSeqs))

labeltr<-c(labelPos,labelNeg)

KNNProtein(seqs=ptmSeqsVect,trainSeq=trainSeq,percent=10,labeltr=labeltr)
}
\references{
Chen, Zhen, et al. "iFeature: a python package and web server for features extraction and selection from protein and peptide sequences." Bioinformatics 34.14 (2018): 2499-2502.
}
