% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maxORFlength_RNA.R
\name{maxORFlength_RNA}
\alias{maxORFlength_RNA}
\title{Maximum Open Reading Frame length in RNA (maxORFlength_RNA)}
\usage{
maxORFlength_RNA(seqs, reverse = TRUE, normalized = FALSE, label = c())
}
\arguments{
\item{seqs}{is a FASTA file containing ribonucleotide sequences. The sequences start
with '>'. Also, seqs could be a string vector. Each element of the vector is a ribonucleotide sequence.}

\item{reverse}{It is a logical parameter which assumes the reverse complement of the sequence.}

\item{normalized}{is a logical parameter. When it is FALSE, the return value of the function does not change. Otherwise, the return value is normalized using the length of the sequence.}

\item{label}{is an optional parameter. It is a vector whose length is equivalent to the number of sequences. It shows the class of
each entry (i.e., sequence).}
}
\value{
A vector containing the lengths of maximum ORFs for each sequence.
}
\description{
This function returns the length of the maximum Open Reading Frame for each sequence.
If reverse is FALSE, ORF region will be searched in a sequence.
Otherwise, it will be searched both in the sequence and its reverse complement.
}
\examples{

fileLNC<-system.file("extdata/Carica_papaya101RNA.txt",package="ftrCOOL")
vect<-maxORFlength_RNA(seqs=fileLNC,reverse=TRUE,normalized=TRUE)

}
