% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PSSM.R
\name{PSSM}
\alias{PSSM}
\title{Position-Specific Scoring Matrix (PSSM)}
\usage{
PSSM(dirPath, outFormat = "mat", outputFileDist = "")
}
\arguments{
\item{dirPath}{Path of the directory which contains all output files of PSI-BLAST. Each file belongs to a sequence.}

\item{outFormat}{It can take two values: 'mat' (which stands for matrix) and 'txt'. The default value is 'mat'.}

\item{outputFileDist}{It shows the path and name of the 'txt' output file.}
}
\value{
The output depends on the outFormat parameter which can be either 'mat' or 'txt'. If outFormat is 'mat', the function returns a feature
matrix for sequences with the same length such that the number of columns is (sequence length)*(20)
and the number of rows is equal to the number of sequences.
If the outFormat is 'txt', the output is written to a tab-delimited file.
}
\description{
This functions receives as input PSSM matrices (which are created by PSI-BLAST software)
and converts them into feature vectors.
}
\note{
This function is provided for sequences with the same lengths.
Users can use 'txt' option in outFormat for sequences with different lengths.
Warning: If outFormat is set to 'mat' for sequences with different lengths, it returns an error.
Also, when output format is 'txt', label information is not shown in the text file.
It is noteworthy that 'txt' format is not usable for machine learning purposes if sequences have different sizes. Otherwise 'txt' format
is also usable for machine learning purposes.
}
\examples{

dir = tempdir()
ad<-paste0(dir,"/pssm.txt")

PSSMdir<-system.file("testForder",package="ftrCOOL")
PSSMdir<-paste0(PSSMdir,"/PSSMdir/")
mat<-PSSM(PSSMdir,outFormat="txt",outputFileDist=ad)


unlink("dir", recursive = TRUE)
}
