% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rename_fude.R
\name{rename_fude}
\alias{rename_fude}
\title{Rename the Fude Polygon data}
\usage{
rename_fude(data, japanese = TRUE)
}
\arguments{
\item{data}{List of \code{\link[sf:sf]{sf::sf()}} objects.}

\item{japanese}{Logical. If \code{FALSE}, rename the local government name in romaji
instead of Japanese. Note that romanization may not be correct.}
}
\value{
A list of \code{\link[sf:sf]{sf::sf()}} objects.
}
\description{
\code{rename_fude()} renames the local government code of the list returned by
\code{\link[=read_fude]{read_fude()}} to the corresponding Japanese name in order to make the data
human-friendly.
}
\examples{
path <- system.file("extdata", "castle.zip", package = "fude")
d <- read_fude(path)
d <- rename_fude(d)
}
\seealso{
\code{\link[=read_fude]{read_fude()}}.
}
