% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ft_extract_corpus.R
\name{ft_extract_corpus}
\alias{ft_extract_corpus}
\title{Extract text from one to many pdf documents into a tm Corpus or Vcorpus.}
\usage{
ft_extract_corpus(paths, which = "xpdf", ...)
}
\arguments{
\item{paths}{Path to one or more pdfs}

\item{which}{One of gs or xpdf.}

\item{...}{further args passed on to \code{readerControl} parameter
in \code{\link[tm]{Corpus}}}
}
\value{
A tm Corpus (or VCorpus, later that is)
}
\description{
Extract text from one to many pdf documents into a tm Corpus or Vcorpus.
}
\examples{
\dontrun{
path <- system.file("examples", "example1.pdf", package = "fulltext")
(res <- ft_extract_corpus(path, "xpdf"))
tm::TermDocumentMatrix(res$data)

(res_gs <- ft_extract_corpus(path, "gs"))
}
}
\seealso{
\code{\link{ft_extract}}
}

