% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/simulation.R
\name{simFunData}
\alias{simFunData}
\title{Simulate univariate functional data}
\usage{
simFunData(argvals, M, eFunType, ignoreDeg = NULL, eValType, N)
}
\arguments{
\item{argvals}{A numeric vector, containing the observation points (a fine grid
on a real interval) of the functional data that is to be simulated.}

\item{M}{An integer, giving the number of unvariate basis functions to use.
See Details.}

\item{eFunType}{A character string specifying the type of univariate
orthonormal basis functions to use. See \code{\link{eFun}} for details.}

\item{ignoreDeg}{A vector of integers, specifying the degrees to ignore when
generating the univariate orthonormal bases. Defaults to \code{NULL}. See
\code{\link{eFun}} for details.}

\item{eValType}{A character string, specifying the type of
eigenvalues/variances used for the generation of the simulated functions
based on the truncated Karhunen-Loeve representation. See
\code{\link{eVal}} for details.}

\item{N}{An integer, specifying the number of multivariate functions to be
  generated.}
}
\value{
\item{simData}{A \code{\linkS4class{funData}} object with \code{N}
  observations, representing the simulated functional data.}
  \item{trueFuns}{A \code{\linkS4class{funData}} object with \code{M}
  observations, representing the true eigenfunction basis used for simulating
  the data.} \item{trueVals}{A vector of numerics, representing the true
  eigenvalues used for simulating the data.}
}
\description{
This functions simulates (univariate) functional data \eqn{f_1,\ldots, f_N} based on a truncated
Karhunen-Loeve representation: \deqn{f_i(t) = \sum_{m = 1}^M \xi_{i,m}
\phi_m(t).} The eigenfunctions (basis functions) \eqn{\phi_m(t)} are generated
using \code{\link{eFun}}, the scores \eqn{\xi_{i,m}} are simulated
independently from a normal distribution with zero mean and decreasing
variance based on the \code{\link{eVal}} function.
}
\examples{
oldPar <- par(no.readonly = TRUE)

# Use Legendre polynomials as eigenfunctions and a linear eigenvalue decrease
test <- simFunData(seq(0,1,0.01), M = 10, eFunType = "Poly", eValType = "linear", N = 10)

plot(test$trueFuns, main = "True Eigenfunctions")
plot(test$simData, main = "Simulated Data")

# The use of ignoreDeg for eFunType = "PolyHigh"
test <- simFunData(seq(0,1,0.01), M = 4, eFunType = "Poly", eValType = "linear", N = 10)
test_noConst <-  simFunData(seq(0,1,0.01), M = 4, eFunType = "PolyHigh",
                            ignoreDeg = 1, eValType = "linear", N = 10)
test_noLinear <-  simFunData(seq(0,1,0.01), M = 4, eFunType = "PolyHigh",
                             ignoreDeg = 2, eValType = "linear", N = 10)
test_noBoth <-  simFunData(seq(0,1,0.01), M = 4, eFunType = "PolyHigh",
                           ignoreDeg = 1:2, eValType = "linear", N = 10)

par(mfrow = c(2,2))
plot(test$trueFuns, main = "Standard polynomial basis (M = 4)")
plot(test_noConst$trueFuns, main = "No constant basis function")
plot(test_noLinear$trueFuns, main = "No linear basis function")
plot(test_noBoth$trueFuns, main = "Neither linear nor constant basis function")

par(oldPar)
}
\seealso{
\code{\linkS4class{funData}}, \code{\link{eFun}}, \code{\link{eVal}},
  \code{\link{addError}}, \code{\link{sparsify}}
}

