% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funDataMethods.R
\name{dimSupp}
\alias{dimSupp}
\title{Support dimension of functional data}
\usage{
dimSupp(object)
}
\arguments{
\item{object}{An object of  class \code{funData}, \code{irregFunData} or \code{multiFunData}.}
}
\value{
If \code{object} is univariate (i.e. of class \code{funData} or \code{irregFunData}), the
  function returns the dimension of the support of \code{object}. If
  \code{object} is multivariate (i.e. of class \code{multiFunData}), the
  function returns a vector, giving the support dimension of each element.
}
\description{
This function returns the support dimension of an object of class
\code{funData}, \code{irregFunData} or \code{multiFunData}.
}
\examples{
# Univariate (one-dimensional)
object1 <- funData(argvals = 1:5, X = rbind(1:5, 6:10))
dimSupp(object1)

# Univariate (two-dimensional)
object2 <- funData(argvals = list(1:10, 1:5), X = array(rnorm(100), dim = c(2,10,5)))
dimSupp(object2)

# Univariate (irregular)
irregObject <- irregFunData(argvals = list(1:5, 2:4), X = list(2:6, 3:5))
dimSupp(irregObject)

# Multivariate
multiObject <- multiFunData(object1, object2)
dimSupp(multiObject)
}
\seealso{
\code{\linkS4class{funData}}, \code{\linkS4class{irregFunData}}, \code{\linkS4class{multiFunData}}
}

