% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMethods.R
\name{autoplot.multiFunData}
\alias{autoplot.multiFunData}
\title{Visualize multivariate functional data objects using ggplot}
\usage{
autoplot.multiFunData(object, obs = seq_len(nObs(object)),
  dim = seq_len(length(object)), plotGrid = FALSE, ...)
}
\arguments{
\item{object}{A \code{multiFunData} object that is to be plotted.}

\item{obs}{A vector of numerics giving the observations to plot. Defaults to all observations in 
\code{object}. For two-dimensional functions (images) \code{obs} must have length 1.}

\item{dim}{The dimensions to plot. Defaults to \code{length(object)}, i.e. all functions in 
\code{object} are plotted.}

\item{plotGrid}{Logical. If \code{TRUE}, the data is plotted using 
\code{\link[gridExtra]{grid.arrange}} and the list of \code{\link[ggplot2]{ggplot}} objects is 
returned invisibly. If \code{FALSE}, only the list of objects is returned. Defaults to 
\code{FALSE}.}

\item{...}{Further parameters passed to the univariate \code{\link{autoplot.funData}} functions for 
\code{funData} objects.}
}
\value{
A list of \code{\link[ggplot2]{ggplot}} objects that are also printed directly as a grid 
  if \code{plotGrid = TRUE}.
}
\description{
This function allows to plot \code{multiFunData} objects based on the \pkg{ggplot2} package. The 
function applies the \code{\link{autoplot.funData}} function to each element and returns either a 
combined plot with all elements plotted in one row or a list containing the different subplots as
\code{\link[ggplot2]{ggplot}} objects. The individual objects can be customized using all 
functionalities of the \pkg{ggplot2} package.
}
\section{Warning}{
 Currently, the function does not accept different parameters for the univariate
  elements.
}

\examples{
# Load packages ggplot2 and gridExtra before running the examples
library("ggplot2"); library("gridExtra")

# One-dimensional elements
argvals <- seq(0, 2*pi, 0.01)
f1 <- funData(argvals, outer(seq(0.75, 1.25, length.out = 11), sin(argvals)))
f2 <- funData(argvals, outer(seq(0.75, 1.25, length.out = 11), cos(argvals)))

m1 <- multiFunData(f1, f2)

g <- autoplot(m1) # default
g[[1]] # plot first element
g[[2]] # plot second element
gridExtra::grid.arrange(grobs = g, nrow = 1) # requires gridExtra package

autoplot(m1, plotGrid = TRUE) # the same directly with plotGrid = TRUE

\donttest{
# Mixed-dimensional elements
X <- array(0, dim = c(11, length(argvals), length(argvals)))
X[1,,] <- outer(argvals, argvals, function(x,y){sin((x-pi)^2 + (y-pi)^2)})
f2 <- funData(list(argvals, argvals), X)

m2 <- multiFunData(f1, f2)

autoplot(m2, obs = 1, plotGrid = TRUE)

# Customizing plots (see ggplot2 documentation for more details)
g2 <- autoplot(m2, obs = 1)
g2[[1]] <- g2[[1]] + ggtitle("First element") + theme_bw()
g2[[2]] <- g2[[2]] + ggtitle("Second element") + 
                     scale_fill_gradient(high = "green", low = "blue")
gridExtra::grid.arrange(grobs = g2, nrow = 1) # requires gridExtra package
}
}
\seealso{
\code{\linkS4class{multiFunData}}, \code{\link[ggplot2]{ggplot}}, 
  \code{\link{plot.multiFunData}}
}
