% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/numbers.R
\name{prep_outliers}
\alias{prep_outliers}
\title{Outliers Data Preparation}
\usage{
prep_outliers(data, str_input = NA, type = c("stop", "set_na"), top_percent,
  bottom_percent)
}
\arguments{
\item{data}{a data frame or a single vector. If it's a data frame, the function returns a data frame, otherwise it returns a vector.}

\item{str_input}{string input variable (if empty, it runs for all numeric variable).}

\item{type}{can be 'stop' or 'set_na', in the first case the original variable is stopped at the desiered percentile, 'set_na'  sets NA to the same values.}

\item{top_percent}{value from 0 to 1, represents the highest X percentage of values to treat}

\item{bottom_percent}{value from 0 to 1, represents the lowest X percentage of values to treat}
}
\value{
A data frame with the desired outlier transformation
}
\description{
Deal with outliers by setting an 'NA value' or by 'stopping' them at a certain. The parameters: 'top_percent'/'bottom_percent' are used to consider a value as outlier.

Setting NA is recommended when doing statistical analysis, parameter: type='set_na'.
Stopping is recommended when creating a predictive model without biasing the result due to outliers, parameter: type='stop'.

The function can take a data frame, and returns the same data plus the transformations specified in the str_input parameter. Or it can take a single vector (in the same 'data' parameter), and it returns a vector.
}
\examples{
\dontrun{
# Creating data frame with outliers
set.seed(10)
df=data.frame(var1=rchisq(1000,df = 1), var2=rnorm(1000))
df=rbind(df, 1135, 2432) # forcing outliers
df$id=as.character(seq(1:1002))

# for var1: mean is ~ 4.56, and max 2432
summary(df)

########################################################
### PREPARING OUTLIERS FOR DESCRIPTIVE STATISTICS
########################################################

#### EXAMPLE 1: Removing top 1\%\% for a single variable
# checking the value for the top 1\% of highest values (percentile 0.99), which is ~ 7.05
quantile(df$var1, 0.99)

# Setting type='set_na' sets NA to the highest value specified by top_percent.
# In this case 'data' parameter is single vector, thus it returns a single vector as well.
var1_treated=prep_outliers(data = df$var1, type='set_na', top_percent  = 0.01)

# now the mean (~ 1) is more accurate, and note that: 1st, median and 3rd
#  quartiles remaining very similar to the original variable.
summary(var1_treated)

#### EXAMPLE 2: Removing top and bottom 1\% for the specified input variables.
vars_to_process=c('var1', 'var2')
df_treated3=prep_outliers(data = df, str_input = vars_to_process, type='set_na',
 bottom_percent = 0.01, top_percent  = 0.01)
summary(df_treated3)

########################################################
### PREPARING OUTLIERS FOR PREDICTIVE MODELING
########################################################

#### EXAMPLE 3: Stopping outliers at the top 1\%\% value for all variables. For example
#   if the top 1\%\% has a value of 7, then all values above will be set to 7. Useful
#   when modeling because outlier cases can be used.
df_treated4=prep_outliers(data = df, top_percent  = 0.01, type='stop')
}
}

