% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lares_model_plots.R
\name{mplot_density}
\alias{mplot_density}
\title{Density plot for discrete and continuous values}
\usage{
mplot_density(tag, score, thresh = 5, model_name = NA, subtitle = NA,
  save = FALSE, subdir = NA, file_name = "viz_distribution.png")
}
\arguments{
\item{tag}{Vector. Real known label}

\item{score}{Vector. Predicted value or model's result}

\item{thresh}{Integer. Threshold for selecting binary or regression
models: this number is the threshold of unique values we should
have in 'tag' (more than: regression; less than: classification)}

\item{model_name}{Character. Model's name}

\item{subtitle}{Character. Subtitle to show in plot}

\item{save}{Boolean. Save output plot into working directory}

\item{subdir}{Character. Sub directory on which you wish to save the plot}

\item{file_name}{Character. File name as you wish to save the plot}
}
\description{
This function plots discrete and continuous values results
}
\seealso{
Other Machine Learning: \code{\link{ROC}},
  \code{\link{mplot_cuts_error}}, \code{\link{mplot_cuts}},
  \code{\link{mplot_full}}, \code{\link{mplot_lineal}},
  \code{\link{mplot_metrics}}, \code{\link{mplot_roc}},
  \code{\link{mplot_splits}}

Other Visualization: \code{\link{mplot_cuts_error}},
  \code{\link{mplot_cuts}}, \code{\link{mplot_full}},
  \code{\link{mplot_lineal}}, \code{\link{mplot_metrics}},
  \code{\link{mplot_roc}}, \code{\link{mplot_splits}},
  \code{\link{theme_lares2}}, \code{\link{theme_lares}}
}
\author{
Bernardo Lares
}
\concept{Machine Learning}
\concept{Visualization}
