% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lares_model_plots.R
\name{scale_x_comma}
\alias{scale_x_comma}
\alias{scale_y_comma}
\alias{scale_x_percent}
\alias{scale_y_percent}
\title{Axis scales format}
\usage{
scale_x_comma(...)

scale_y_comma(...)

scale_x_percent(...)

scale_y_percent(...)
}
\arguments{
\item{...}{Arguments passed on to \code{ggplot2::continuous_scale}
\describe{
  \item{aesthetics}{The names of the aesthetics that this scale works with}
  \item{scale_name}{The name of the scale}
  \item{palette}{A palette function that when called with a numeric vector with
values between 0 and 1 returns the corresponding values in the range the
scale maps to.}
  \item{name}{The name of the scale. Used as the axis or legend title. If
\code{waiver()}, the default, the name of the scale is taken from the first
mapping used for that aesthetic. If \code{NULL}, the legend title will be
omitted.}
  \item{breaks}{One of:
\itemize{
\item \code{NULL} for no breaks
\item \code{waiver()} for the default breaks computed by the
transformation object
\item A numeric vector of positions
\item A function that takes the limits as input and returns breaks
as output
}}
  \item{minor_breaks}{One of:
\itemize{
\item \code{NULL} for no minor breaks
\item \code{waiver()} for the default breaks (one minor break between
each major break)
\item A numeric vector of positions
\item A function that given the limits returns a vector of minor breaks.
}}
  \item{labels}{One of:
\itemize{
\item \code{NULL} for no labels
\item \code{waiver()} for the default labels computed by the
transformation object
\item A character vector giving labels (must be same length as \code{breaks})
\item A function that takes the breaks as input and returns labels
as output
}}
  \item{limits}{One of:
\itemize{
\item \code{NULL} to use the default scale range
\item A numeric vector of length two providing limits of the scale.
Use \code{NA} to refer to the existing minimum or maximum
\item A function that accepts the existing (automatic) limits and returns
new limits
}}
  \item{rescaler}{Used by diverging and n colour gradients
(i.e. \code{\link[=scale_colour_gradient2]{scale_colour_gradient2()}}, \code{\link[=scale_colour_gradientn]{scale_colour_gradientn()}}).
A function used to scale the input values to the range [0, 1].}
  \item{oob}{Function that handles limits outside of the scale limits
(out of bounds). The default replaces out of bounds values with \code{NA}.}
  \item{na.value}{Missing values will be replaced with this value.}
  \item{trans}{Either the name of a transformation object, or the
object itself. Built-in transformations include "asn", "atanh",
"boxcox", "date", "exp", "hms", "identity", "log", "log10", "log1p", "log2",
"logit", "modulus", "probability", "probit", "pseudo_log", "reciprocal",
"reverse", "sqrt" and "time".

A transformation object bundles together a transform, its inverse,
and methods for generating breaks and labels. Transformation objects
are defined in the scales package, and are called \code{name_trans}, e.g.
\code{\link[scales:boxcox_trans]{scales::boxcox_trans()}}. You can create your own
transformation with \code{\link[scales:trans_new]{scales::trans_new()}}.}
  \item{guide}{A function used to create a guide or its name. See
\code{\link[=guides]{guides()}} for more info.}
  \item{super}{The super class to use for the constructed scale}
}}
}
\description{
The `_comma` ones set comma format for axis text and the `_percent`
ones set percent format for axis text.
}
