# WARNING - Generated by {fusen} from /dev/flat_package.Rmd: do not edit by hand

#' Permutation-based computation of p-values
#' 
#'
#' 
#' @description Computation of the p-values associated to any statistics
#' described in the package with the permutation methods. See Smida et al 
#' (2022) for more details.
#' 
#' @inheritParams comp_stat
#' @param n_perm integer, number of permutation to compute the p-values.
#' @param verbose boolean, if TRUE, enable verbosity.
#' 
#' @return list of named numeric value corresponding to the p-values for each 
#' statistic listed in the `stat` input.
#' 
#' @inherit authorship author
#' 
#' @references
#' Zaineb Smida, Lionel Cucala, Ali Gannoun & Ghislain Durif (2022) 
#' A median test for functional data, Journal of Nonparametric Statistics, 
#' 34:2, 520-553,  
#' \doi{10.1080/10485252.2022.2064997}, 
#' [hal-03658578](https://hal.science/hal-03658578)
#' 
#' @seealso [funStatTest::stat_mo()], [funStatTest::stat_med()], 
#' [funStatTest::stat_wmw()], [funStatTest::stat_hkr()], 
#' [funStatTest::stat_cff()], [funStatTest::comp_stat()]
#' 
#' @export
#' 
#' @examples
#' # simulate small data for the example
#' simu_data <- simul_data(
#'     n_point = 20, n_obs1 = 4, n_obs2 = 5, c_val = 10, 
#'     delta_shape = "constant", distrib = "normal"
#' )
#' 
#' MatX <- simu_data$mat_sample1
#' MatY <- simu_data$mat_sample2
#' res <- permut_pval(
#'     MatX, MatY, n_perm = 100, stat = c("mo", "med", "wmw", "hkr", "cff"), 
#'     verbose = TRUE)
#' res
permut_pval <- function(
    MatX, MatY, n_perm = 100, stat = c("mo", "med"), verbose = FALSE) {
    
    assert_matrix(MatX)
    assert_numeric(MatX)
    assert_matrix(MatY)
    assert_numeric(MatY)
    assert_count(n_perm, positive = TRUE)
    assert_subset(stat, c("mo", "med", "wmw", "hkr", "cff"), empty.ok = FALSE)
    assert_logical(verbose, len = 1)
    
    # original values on non-permuted samples
    o_stat_val <- comp_stat(MatX, MatY, stat)
    
    # compute permutation-based stat values
    perm_stat_val <- permut_stats(MatX, MatY, n_perm, stat, verbose)
    
    # compute p-values
    pval <- lapply(
        stat, 
        function(stat_name) {
            tmp_res <- pval_stat(
                o_stat_val[[stat_name]], perm_stat_val[[stat_name]])
            return(tmp_res)
        }
    )
    names(pval) <- stat
    
    return(pval)
}
