% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00_mfd.R
\name{rbind_mfd}
\alias{rbind_mfd}
\title{Bind replications of two Multivariate Functional Data Objects}
\usage{
rbind_mfd(mfdobj1, mfdobj2)
}
\arguments{
\item{mfdobj1}{An object of class mfd, with the same variables of mfdobj2
and different replication names with respect to mfdobj2.}

\item{mfdobj2}{An object of class mfd, with the same variables of mfdobj1,
and different replication names with respect to mfdobj1.}
}
\value{
An object of class mfd, whose variables are the same of mfdobj1 and
mfdobj2 and whose replications are the union of the replications
in mfdobj1 and mfdobj2.
}
\description{
Bind replications of two Multivariate Functional Data Objects
}
\examples{
library(funcharts)
mfdobj1 <- data_sim_mfd(nvar = 3, seed = 1, nobs = 4)
mfdobj2 <- data_sim_mfd(nvar = 3, seed = 2, nobs = 5)
dimnames(mfdobj2$coefs)[[2]] <-
  mfdobj2$fdnames[[2]] <-
  c("rep11", "rep12", "rep13", "rep14", "rep15")
mfdobj_rbind <- rbind_mfd(mfdobj1, mfdobj2)
plot_mfd(mfdobj_rbind)

}
