% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00_mfd.R
\name{get_mfd_list}
\alias{get_mfd_list}
\title{Get Multivariate Functional Data from a list of matrices}
\usage{
get_mfd_list(
  data_list,
  grid = NULL,
  n_basis = 30,
  n_order = 4,
  basisobj = NULL,
  Lfdobj = 2,
  lambda = NULL,
  lambda_grid = 10^seq(-10, 1, length.out = 10),
  ncores = 1
)
}
\arguments{
\item{data_list}{A named list of matrices.
Names of the elements in the list denote the functional variable names.
Each matrix in the list corresponds to a functional variable.
All matrices must have the same dimension, where
the number of rows corresponds to replications, while
the number of columns corresponds to the argument values at which
functions are evaluated.}

\item{grid}{A numeric vector, containing the argument values at which
functions are evaluated.
Its length must be equal to the number of columns
in each matrix in data_list.
Default is NULL, in this case a vector equally spaced numbers
between 0 and 1 is created,
with as many numbers as the number of columns in each matrix in data_list.}

\item{n_basis}{An integer variable specifying the number of basis functions;
default value is 30.
See details on basis functions.}

\item{n_order}{An integer specifying the order of B-splines,
which is one higher than their degree.
The default of 4 gives cubic splines.}

\item{basisobj}{An object of class \code{basisfd} defining the
B-spline basis function expansion.
Default is \code{NULL}, which means that
a \code{basisfd} object is created by doing
\code{create.bspline.basis(rangeval = domain,
nbasis = n_basis,  norder = n_order)}}

\item{Lfdobj}{An object of class \code{Lfd} defining a linear
differential operator of order m.
It is used to specify a roughness penalty through \code{fdPar}.
Alternatively, a nonnegative integer specifying
the order m can be given and is
passed as \code{Lfdobj} argument to the function \code{fdPar},
which indicates that the derivative of order m is penalized.
Default value is 2, which means that the integrated
squared second derivative is penalized.}

\item{lambda}{A non-negative real number.
If you want to use a single specified smoothing parameter
for all functional data objects in the dataset,
this argument is passed to the function \code{fda::fdPar}.
Default value is NULL, in this case the smoothing parameter is chosen
by minimizing the generalized cross-validation (GCV) criterion
over the grid of values given by the argument.
See details on how smoothing parameters work.}

\item{lambda_grid}{A vector of non-negative real numbers.
If \code{lambda} is provided as a single number, this argument is ignored.
If \code{lambda} is NULL, then this provides
the grid of values over which the optimal smoothing parameter is
searched. Default value is \code{10^seq(-10,1,l=20)}.}

\item{ncores}{Deprecated.}
}
\value{
An object of class \code{mfd}.
See also \code{\link{mfd}} for additional details
on the multivariate functional data class.
}
\description{
Get Multivariate Functional Data from a list of matrices
}
\details{
Basis functions are created with
\code{fda::create.bspline.basis(domain, n_basis)}, i.e.
B-spline basis functions of order 4 with equally spaced knots
are used to create \code{mfd} objects.

The smoothing penalty lambda is provided as
\code{fda::fdPar(bs, 2, lambda)},
where bs is the basis object and 2 indicates that
the integrated squared second derivative is penalized.

Rather than having a list of matrices,
you may have a data frame with long format,
i.e. with all functional observations in a single column
for each functional variable.
In this case, see \code{get_mfd_df}.
}
\examples{
library(funcharts)
data("air")
# Only take first 5 multivariate functional observations
# and only two variables from air
air_small <- lapply(air[c("NO2", "CO")], function(x) x[1:5, ])
mfdobj <- get_mfd_list(data_list = air_small)

}
\seealso{
\code{\link{mfd}},
\code{\link{get_mfd_list}},
\code{\link{get_mfd_array}}
}
