% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibrating.R
\name{calibrate_amean_byelt_xpr}
\alias{calibrate_amean_byelt_xpr}
\title{Modelling of performances
 by components occurring within an assembly motif
 over several experiments}
\usage{
calibrate_amean_byelt_xpr(fobs, assMotif, mOccur, xpr)
}
\arguments{
\item{fobs}{a numeric vector. The vector \code{fobs} contains the
quantitative performances of assemblages.}

\item{assMotif}{a vector of labels of \code{length(fobs)}.
The vector \code{assMotif} contains the assembly motifs of assemblages.}

\item{mOccur}{a matrix of occurrence (occurrence of components).
Its first dimension equals to \code{length(fobs)}. Its second dimension
 equals to the number of components.}

\item{xpr}{a vector of numerics of \code{length(fobs)}.
The vector \code{xpr} contains the weight of each experiment,
and the labels (in \code{names(xpr)}) of different experiments.
The weigth of each experiment is used
in the computation of the Residual Sum of Squares
in the function \code{rss_clustering}.
All assemblages that belong to a given experiment
should then have a same weigth.
Each experiment is identified by its names (\code{names(xpr)})
and the RSS of each experiment is weighted by values of \code{xpr}.
The vector \code{xpr} is generated
by the function \code{stats::setNames}.}
}
\value{
Return a vector of \code{length(fobs)}.
Its values are computed as the average
of mean performances of assemblages
that share the same assembly motif
and that contain the same components
as the assemblage to calibrate \code{opt.model = "byelt"} .
}
\description{
Take a vector \code{fobs}
of performances of assemblages
and return a vector of performances
predicted as the arithmetic mean
of performances of assemblages
that share a same assembly motif
and that contain the same components as the assemblage to calibrate. \cr

The assembly motifs are labelled in the vector \code{assMotif}.\cr

The component composition of assemblages is specified
in the binary matrix \code{mOccur}:
\code{0} if the component does not occur,
\code{1} if the component occurs.
}
\details{
Modelled performances are computed
using arithmetic mean (\code{opt.mean = "amean"}) of performances.
Assemblages share a same assembly motif.
Modelled performances are the average
of mean performances of assemblages that contain the same components
as the assemblage to calibrate (\code{opt.model = "byelt"}).
This procedure corresponds to a linear model with each assembly motif
based on the component occurrence in each assemblage.
If no assemblage contains component belonging to assemblage to calibrate,
performance is the mean performance of all assemblages.
}
\seealso{
\code{\link{calibrate_amean_bymot_xpr}} arithmetic mean
  by assembly motif. \cr
\code{\link{calibrate_amean_byelt_xpr}} arithmetic mean
  by elements occurring within assembly motif. \cr
\code{\link{calibrate_gmean_bymot_xpr}} geometric mean
  by assembly motif. \cr
\code{\link{calibrate_gmean_byelt_xpr}} geometric mean
  by elements occurring within assembly motif. \cr
}
\keyword{internal}
