% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ravgr.R
\name{Ravgr}
\alias{Ravgr}
\title{Generate a random R matrix with an average rij}
\usage{
Ravgr(R, rdist = "U", alpha = 4, beta = 2)
}
\arguments{
\item{R}{(matrix) An n x n correlation matrix with a known, average rij.}

\item{rdist}{(character). A character that controls the variance of the off 
diagonal elements of the generated R. If \code{rdist="U"} then the R 
matrices are uniformly  sampled from the space of all n x n R matrices with a 
fixed average rij.  If \code{rdist = "B"} then the R matrices are 
selected as a function of the \code{alpha} and \code{beta} arguments of a 
Beta distribution. Default \code{rdist= "U"}. See Waller (2023) for details.}

\item{alpha}{(numeric) The shape1 parameter of a beta distribution.}

\item{beta}{(numeric)  The shape2 parameter of a beta distribution.}
}
\value{
A random R matrix with a known, average off-diagonal element.
}
\description{
Ravgr(R, rdist = "U", alpha = 4, beta = 2)
}
\examples{

  R <- matrix(.35, 6, 6)
  diag(R) <- 1
  
  Rout <- Ravgr(R, 
               rdist = "U")
               
  Rout |> round(3)            
  mean( Rout[upper.tri(Rout, diag = FALSE)] )
  
  
  # Generate an R matrix with a larger var(rij)
  Rout <- Ravgr(R, 
               rdist = "B",
               alpha = 7,
               beta = 2)
               
  Rout |> round(3)            
  mean( Rout[upper.tri(Rout, diag = FALSE)] )
   
}
\references{
Waller, N. G. (2023). Generating correlation matrices with a 
user-defined average correlation. Manuscript under review.
}
\author{
Niels G. Waller
}
