% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RGen.R
\name{RGen}
\alias{RGen}
\title{Generate random R matrices with various user-defined properties via 
differential evolution (DE).}
\usage{
RGen(
  Nvar = 3,
  NMatrices = 1,
  Minr = -1,
  Maxr = 1,
  MinEig = 0,
  MaxIter = 200,
  delta = 1e-08,
  PRINT = FALSE,
  Seed = NULL
)
}
\arguments{
\item{Nvar}{(integer) The order of the generated correlation matrices.}

\item{NMatrices}{(integer) Generate \code{NMatrices}
correlation matrices.}

\item{Minr}{(numeric > -1 and < Maxr)  The minimum  rij in 
the generated R matrices.  Default \code{Minr = -1}.}

\item{Maxr}{(numeric > Minr and <= 1). The maximum  rij in the 
generated R matrices.  Default \code{Maxr = 1}.}

\item{MinEig}{(numeric). Minimum size of the last eigenvalue of R. Default 
\code{MinEig = 0}. By setting \code{MinEig} to a value slightly greater than 
0 (e.g., 1E-3), all generated matrices will be positive definite.}

\item{MaxIter}{(integer) The maximum number of iterations
(i.e., generations) for the DE optimizer. Default \code{MaxIter = 200}.}

\item{delta}{(numeric > 0) A number that controls the convergence
accuracy of the differential evolution algorithm. Default \code{delta = 1E-8}.}

\item{PRINT}{(logical) When PRINT = TRUE the algorithm convergence status is printed.
Default  \code{PRINT = FALSE}.}

\item{Seed}{(integer) Initial random number seed. Default (\code{Seed = NULL}).}
}
\value{
\code{RGen} returns the following objects:
\itemize{
   \item  \strong{R} (matrix) A list of generated correlation matrices.
   \item  \strong{converged}: (logical) a logical that indicates the 
   convergence status of the optimization for each matrix.
   \item \strong{iter} (integer) The number of cycles needed to reach a 
   converged solution for each matrix.
}
}
\description{
Generate random R matrices with various user-defined properties via 
differential evolution (DE).
}
\examples{
## Example 1: Generate random 4 x 4 Correlation matrices.

  out <- RGen(Nvar = 4,
              NMatrices = 4,
              PRINT = TRUE,
              Seed = 1)
                      
  # Check convergence status of all matrices                     
  print( table(out$converged) )                     

  print( round( out$R[[1]] , 3) )


}
\references{
Ardia, D., Boudt, K., Carl, P., Mullen, K.M., Peterson, B.G. (2011) Differential
Evolution with DEoptim. An Application to Non-Convex Portfolio Optimization.
URL The R Journal, 3(1), 27-34.
URL https://journal.r-project.org/archive/2011-1/RJournal_2011-1_Ardia~et~al.pdf.

Georgescu, D. I., Higham, N. J., and Peters, G. W.  (2018).  Explicit
solutions to correlation matrix completion problems, with
an application to risk management and insurance.  Royal Society Open
Science, 5(3), 172348.

Mishra, S. K.  (2007).  Completing correlation matrices
of arbitrary order by differential evolution method of global optimization:
a Fortran program.  Available at SSRN 968373.

Mullen, K.M, Ardia, D., Gil, D., Windover, D., Cline, J. (2011). DEoptim: An
R Package for Global Optimization by Differential Evolution. Journal of Statistical Software, 40(6), 1-26. URL http://www.jstatsoft.org/v40/i06/.

Price, K.V., Storn, R.M., Lampinen J.A. (2005) Differential Evolution - A Practical Approach to Global Optimization. Berlin Heidelberg:
Springer-Verlag. ISBN 3540209506.

Zhang, J. and Sanderson, A. (2009) Adaptive Differential
Evolution Springer-Verlag. ISBN 978-3-642-01526-7
}
\author{
Niels G. Waller
}
