% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/faStandardize.R
\name{faStandardize}
\alias{faStandardize}
\title{Standardize the Unrotated Factor Loadings}
\usage{
faStandardize(method, lambda)
}
\arguments{
\item{method}{(Character) The method used for standardization. There are three option: "none", "Kaiser", and "CM".
\itemize{
  \item \strong{"none"}: No standardization is conducted on the unrotated factor loadings matrix
  \item \strong{"Kaiser"}: The rows of the unrotated factor loadings matrix are rescaled to have unit-lengths.
  \item \strong{"CM"}: Apply the Cureton-Mulaik standardization to the unrotated factor loadings matrix.
}}

\item{lambda}{(Matrix) The unrotated factor loadings matrix (or data frame).}
}
\value{
The resulting output can be used to standardize the factor loadings as well as providing the inverse matrix used to unstandardize the factor loadings after rotating the factor solution.
\itemize{
  \item \strong{Dv}: (Matrix) A diagonal weight matrix used to standardize the unrotated factor loadings. Pre-multiplying the loadings matrix by the diagonal weight matrix (i.e., Dv %*% lambda) is how to standardization occurs.
  \item \strong{DvInv}: (Matrix) The inverse of the diagonal weight matrix used to standardize. To unstandardize the ultimate rotated solution, pre-multiply the rotated factor loadings by the inverse of Dv (i.e., DvInv %*% rotatedLambda) to obtain finish the standardization process.
  \item \strong{lambda}: (Matrix) The standardized, unrotated factor loadings matrix.
  \item \strong{unstndLambda}: (Matrix) The original, unstandardized, unrotated factor loadings matrix. (DvInv %*% lambda == unstndLambda)
}
}
\description{
This function standardizes the unrotated factor loadings using two methods: Kaiser's normalization and Cureton-Mulaik standardization.
}
\references{
Browne, M. W. (2001). An overview of analytic rotation in exploratory factor analysis. \emph{Multivariate Behavioral Research, 36}(1), 111-150.

Cureton, E. E., & Mulaik, S. A. (1975). The weighted varimax rotation and the promax rotation. \emph{Psychometrika, 40}(2), 183-195.
}
\seealso{
Other Factor Analysis Routines: 
\code{\link{BiFAD}()},
\code{\link{Box26}},
\code{\link{GenerateBoxData}()},
\code{\link{Ledermann}()},
\code{\link{SLi}()},
\code{\link{SchmidLeiman}()},
\code{\link{faAlign}()},
\code{\link{faEKC}()},
\code{\link{faIB}()},
\code{\link{faLocalMin}()},
\code{\link{faMB}()},
\code{\link{faMain}()},
\code{\link{faScores}()},
\code{\link{faSort}()},
\code{\link{faX}()},
\code{\link{fals}()},
\code{\link{fapa}()},
\code{\link{fareg}()},
\code{\link{fsIndeterminacy}()},
\code{\link{orderFactors}()},
\code{\link{print.faMB}()},
\code{\link{print.faMain}()},
\code{\link{promaxQ}()},
\code{\link{summary.faMB}()},
\code{\link{summary.faMain}()}
}
\concept{Factor Analysis Routines}
