% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/obj_func.R
\name{obj_func}
\alias{obj_func}
\title{Objective function for optimizing RMSEA and CFI}
\usage{
obj_func(
  par = c(v, eps),
  Rpop,
  W,
  p,
  u,
  df,
  target_rmsea,
  target_cfi,
  weights = c(1, 1),
  WmaxLoading = NULL,
  NWmaxLoading = 2,
  penalty = 0,
  return_values = FALSE
)
}
\arguments{
\item{par}{(vector) Values of model error variance (\eqn{\nu_{\textrm{e}}}) and
epsilon (\eqn{\epsilon}).}

\item{Rpop}{(matrix) The model-implied correlation matrix.}

\item{W}{(matrix) Matrix of provisional minor common factor loadings with
unit column variances.}

\item{p}{(scalar) Number of variables.}

\item{u}{(vector) Major common factor variances.}

\item{df}{(scalar) Model degrees of freedom.}

\item{target_rmsea}{(scalar) Target RMSEA value.}

\item{target_cfi}{(scalar) Target CFI value.}

\item{weights}{(vector) Vector of length two indicating how much weight to
give RMSEA and CFI, e.g., `c(1,1)` (default) gives equal weight to both
indices; `c(1,0)` ignores the CFI value.}

\item{WmaxLoading}{(scalar) Threshold value for `NWmaxLoading`.}

\item{NWmaxLoading}{(scalar) Maximum number of absolute loadings \eqn{\ge}
`WmaxLoading` in any column of `W`.}

\item{penalty}{(scalar) Large (positive) penalty value to apply if the
NWmaxLoading condition is violated.}

\item{return_values}{(boolean) If `TRUE`, return the objective function value
along with `Rpop`, `RpopME`, `W`, `RMSEA`, `CFI`, `v`, and `eps` values. If
`FALSE`, return only the objective function value.}
}
\description{
This is the objective function that is minimized by the \code{\link{tkl}} function.
}
