% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verify_palettes.R
\name{verify_palettes}
\alias{verify_palettes}
\title{Verify the integrity of the palettes object}
\usage{
verify_palettes(palettes, column_info, data)
}
\arguments{
\item{palettes}{A named list of palettes. Each entry in \code{column_info$palette}
should have an entry in this object. If an entry is missing, the type
of the column will be inferred (categorical or numerical) and one of the
default palettes will be applied. Alternatively, the name of one of the
standard palette names can be used:
\itemize{
\item \code{numerical}: \code{"Greys"}, \code{"Blues"}, \code{"Reds"}, \code{"YlOrBr"}, \code{"Greens"}
\item \code{categorical}: \code{"Set3"}, \code{"Set1"}, \code{"Set2"}, \code{"Dark2"}
}}

\item{column_info}{A data frame describing which columns in \code{data} to
plot. This data frame should contain the following columns:
\itemize{
\item \code{id} (\code{character}, required): A column name in \code{data} to plot. Determines the
size of the resulting geoms, and also the color unless \code{color} is
specified.
\item \code{id_color} (\code{character}): A column name in \code{data} to use for the color
of the resulting geoms. If \code{NA}, the \code{id} column will be used.
\item \code{id_size} (\code{character}): A column name in \code{data} to use for the size
of the resulting geoms. If \code{NA}, the \code{id} column will be used.
\item \code{name} (\code{character}): A label for the column. If \code{NA} or \code{""},
no label will be plotted. If this column is missing, \code{id} will
be used to generate the \code{name} column.
\item \code{geom} (\code{character}): The geom of the column. Must be one of:
\code{"funkyrect"}, \code{"circle"}, \code{"rect"}, \code{"bar"}, \code{"pie"}, \code{"text"} or \code{"image"}.
For \code{"text"}, the corresponding column in \code{data} must be a \code{character}.
For \code{"pie"}, the column must be a list of named numeric vectors.
For all other geoms, the column must be a \code{numeric}.
\item \code{group} (\code{character}): The grouping id of each column, must match with
\code{column_groups$group}. If this column is missing or all values are \code{NA},
columns are assumed not to be grouped.
\item \code{palette} (\code{character}): Which palette to colour the geom by.
Each value should have a matching value in \code{palettes$palette}.
\item \code{width}: Custom width for this column (default: 1).
\item \code{overlay}: Whether to overlay this column over the previous column.
If so, the width of that column will be inherited.
\item \code{legend}: Whether or not to add a legend for this column.
\item \code{hjust}: Horizontal alignment of the bar, must be between [0,1]
(only for \code{geom = "bar"}).
\item \code{vjust}: Vertical alignment of the label, must be between [0,1]
(only for \code{geom = "text"}).
\item \code{size}: Size of the label, must be a numeric value
(only for \code{geom = "text"}).
\item \code{label}: Which column to use as a label (only for \code{geom = "text"}).
\item \code{directory}: Which directory to use to find the images (only for \code{geom = "image"}).
\item \code{extension}: The extension of the images (only for \code{geom = "image"}).
\item \code{draw_outline}: Whether or not to draw bounding guides (only for \code{geom == "bar"}).
Default: \code{TRUE}.
\item \code{options} (\code{list} or \code{json}): Any of the options above. Any values in this
column will be spread across the other columns. This is useful for
not having to provide a data frame with 1000s of columns.
This column can be a json string.
}}

\item{data}{A data frame with items by row and features in the columns.
Must contain one column named \code{"id"}.}
}
\value{
The palettes object with all expected columns.
}
\description{
Verify the integrity of the palettes object
}
\examples{
library(tibble)
library(grDevices)
library(RColorBrewer)

# explicit form
data <- tribble(
  ~id, ~name, ~x, ~y,
  "foo", "Foo", 0.5, 0.7,
  "bar", "Bar", 1.0, 0.1
)
column_info <- tribble(
  ~id, ~geom, ~palette,
  "name", "text", NA,
  "foo", "funkyrect", "pal1",
  "bar", "funkyrect", "pal2"
)
palettes <- list(
  pal1 = rev(brewer.pal(9, "Greys")[-1]),
  pal2 = rev(brewer.pal(9, "Reds")[-8:-9])
)
verify_palettes(palettes, column_info, data)

# implicit palettes
palettes <- list(
  pal1 = "Greys",
  pal2 = "Reds"
)
verify_palettes(palettes, column_info, data)

# passing a tibble should also work (for backwards compatibility)
palettes <- tribble(
  ~palette, ~colours,
  "pal1", rev(brewer.pal(9, "Greys")[-1]),
  "pal2", rev(brewer.pal(9, "Reds")[-8:-9])
)
verify_palettes(palettes, column_info, data)
}
