% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/position_arguments.R
\name{position_arguments}
\alias{position_arguments}
\title{Defines parameters for positioning in a plot.}
\usage{
position_arguments(
  row_height = 1,
  row_space = 0.1,
  row_bigspace = 1.2,
  col_width = 1,
  col_space = 0.1,
  col_bigspace = 0.5,
  col_annot_offset = 3,
  col_annot_angle = 30,
  expand_xmin = 0,
  expand_xmax = 2,
  expand_ymin = 0,
  expand_ymax = 0
)
}
\arguments{
\item{row_height}{The height of the rows.}

\item{row_space}{The space between rows.}

\item{row_bigspace}{The large space between row groups.}

\item{col_width}{The width of the columns.}

\item{col_space}{The space between columns.}

\item{col_bigspace}{The large space between column groups.}

\item{col_annot_offset}{How much the column annotation will be offset by.}

\item{col_annot_angle}{The angle of the column annotation labels.}

\item{expand_xmin}{The minimum expansion of the plot in the x direction.}

\item{expand_xmax}{The maximum expansion of the plot in the x direction.}

\item{expand_ymin}{The minimum expansion of the plot in the y direction.}

\item{expand_ymax}{The maximum expansion of the plot in the y direction.}
}
\value{
A list of plot positioning parameters.
}
\description{
This function sets parameters that affect positioning within a
plot, such as row and column dimensions, annotation details, and the
expansion directions of the plot.
}
\examples{
position_arguments(row_height = 1.2, col_width = 1.5, expand_xmax = 3)
}
