% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verify_row_groups.R
\name{verify_row_groups}
\alias{verify_row_groups}
\title{Verify the integrity of the row groups object}
\usage{
verify_row_groups(row_groups, row_info)
}
\arguments{
\item{row_groups}{A data frame describing of how to group the rows
in \code{row_info}. Can consist of the following columns:
\itemize{
\item \code{group} (\code{character}): The corresponding group in \code{row_info$group}.
\item \code{level1} (\code{character}): The label at the highest level.
\item \code{level2} (\code{character}, optional): The label at the middle level.
\item \code{level3} (\code{character}, optional): The label at the lowest level
(not recommended).
}}

\item{row_info}{A data frame describing the rows of \code{data}.
This data should contain two columns:
\itemize{
\item \code{id} (\code{character}): Corresponds to the column \code{data$id}.
\item \code{group} (\code{character}): The group of the row.
If all are \code{NA}, the rows will not be split up into groups.
}}
}
\value{
The row groups object with all expected rows.
}
\description{
Verify the integrity of the row groups object
}
\examples{
library(tibble)
row_groups <- tribble(
  ~group, ~level1,
  "foo", "Foo",
  "bar", "Bar"
)
row_info <- tribble(
  ~id, ~group,
  "name", NA_character_,
  "foo1", "foo",
  "foo2", "foo",
  "bar1", "bar",
  "bar2", "bar"
)
verify_row_groups(row_groups, row_info)
}
