% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unique_by.R
\name{unique_by}
\alias{unique_by}
\title{Unique with auxiliary function}
\usage{
unique_by(x, f, first = TRUE)
}
\arguments{
\item{x}{a vector or a list.}

\item{f}{a function to apply to each element of \code{x}. This function must
produce comparable results.}

\item{first}{if several elements are identical after being transformed by
\code{f}, keep the first. Otherwise, keep the last.}
}
\value{
An object of the same type as x. Only elements that are unique after
  being transformed by \code{f} are kept.
}
\description{
Remove duplicate elements, given a transformation.
}
\examples{
unique_by(-3:2, abs)
unique_by(-3:2, abs, first = FALSE)
unique_by(c(1, 2, 4, 5, 6), function(x) x \%\% 3)
unique_by(list(1:2, 2:3, 2:4), length)
}
