% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Simple_Table1.R
\name{simple_table1}
\alias{simple_table1}
\title{Simple Table 1 for Simple and Stratified Descriptive Statistics}
\usage{
simple_table1(.data, ..., splitby = NULL, row_wise = FALSE,
  splitby_labels = NULL, test = FALSE, piping = FALSE, rounding = 2,
  var_names = NULL, format_output = "pvalues", output_type = "text",
  format_number = FALSE, NAkeep = FALSE, m_label = "Missing",
  booktabs = TRUE, caption = NULL, align = NULL)
}
\arguments{
\item{.data}{the data.frame that is to be summarized}

\item{...}{variables in the data set that are to be summarized; unquoted names separated by commas (e.g. age, gender, race) or indices. If indices, it needs to be a single vector (e.g. c(1:5, 8, 9:20) instead of 1:5, 8, 9:20). As it is currently, it CANNOT handle both indices and unquoted names simultaneously.}

\item{splitby}{the categorical variable to stratify by in formula form (e.g., \code{splitby = ~gender}); not too surprisingly, it requires that the number of levels be > 0}

\item{row_wise}{how to calculate percentages for factor variables when \code{splitby != NULL}: if \code{FALSE} calculates percentages by variable within groups; if \code{TRUE} calculates percentages across groups for one level of the factor variable.}

\item{splitby_labels}{allows for custom labels of the splitby levels; must match the number of levels of the splitby variable}

\item{test}{logical; if set to \code{TRUE} then the appropriate bivariate tests of significance are performed if splitby has more than 1 level}

\item{piping}{if \code{TRUE} then the table is printed and the original data is passed on. It is very useful in piping situations where one wants the table but wants it to be part of a larger pipe.}

\item{rounding}{the number of digits after the decimal for means and SD's; default is 2}

\item{var_names}{custom variable names to be printed in the table}

\item{format_output}{has three options: 1) "full" provides the table with the type of test, test statistic, and the p-value for each variable; 2) "pvalues" provides the table with the p-values; and 3) "stars" provides the table with stars indicating significance}

\item{output_type}{default is "text"; the other options are all format options in the \code{kable()} function in \code{knitr} (e.g., latex, html, markdown, pandoc)}

\item{format_number}{default in FALSE; if TRUE, then the numbers are formatted with commas (e.g., 20,000 instead of 20000)}

\item{NAkeep}{when sset to \code{TRUE} it also shows how many missing values are in the data for each categorical variable being summarized}

\item{m_label}{when \code{NAkeep = TRUE} this provides a label for the missing values in the table}

\item{booktabs}{when \code{output_type != "text"}; option is passed to \code{knitr::kable}}

\item{caption}{when \code{output_type != "text"}; option is passed to \code{knitr::kable}}

\item{align}{when \code{output_type != "text"}; option is passed to \code{knitr::kable}}
}
\value{
A table with the number of observations, means/frequencies and standard deviations/percentages is returned. The object is a \code{table1} class object with a print method. Can be printed in \code{LaTex} form.
}
\description{
Produces a simple version of Table 1:
a descriptive table, stratified by an optional categorical variable, 
providing means/frequencies and standard deviations/percentages. 
It is well-formatted for easy transition to academic article or report. 
Can be used within the piping framework [see library(magrittr)].
}
\examples{
## Ficticious Data ##
library(furniture)
library(tidyverse)

x  <- runif(1000)
y  <- rnorm(1000)
z  <- factor(sample(c(0,1), 1000, replace=TRUE))
a  <- factor(sample(c(1,2), 1000, replace=TRUE))
df <- data.frame(x, y, z, a)

## Simple
simple_table1(df, x, y, z, a)

## Stratified
## both below are the same
simple_table1(df, x, y, z,
              splitby = ~ a)
simple_table1(df, x, y, z,
              splitby = "a")

## Adjust variables within function
simple_table1(df, ifelse(x > 0, 1, 0), z,
              var_names = c("Dich X", "Z"))
         

}

