% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rowmeans.R
\name{rowsums.n}
\alias{rowsums.n}
\title{Get Row Sums With N Missing Values Per Row}
\usage{
rowsums.n(..., n)
}
\arguments{
\item{...}{the variables (unquoted) to be included in the row means}

\item{n}{the number of values without missingness required to get the row mean}
}
\value{
the row sums
}
\description{
Does what \code{furniture::rowsums()} does while allowing a certain number (\code{n}) to have missing values.
}
\examples{

\dontrun{

library(furniture)
library(dplyr)

data <- data.frame(
  x = sample(c(1,2,3,4), 100, replace=TRUE),
  y = rnorm(100),
  z = rnorm(100)
)

data2 <- mutate(data, x_y_z_mean = rowsums.n(x, y, z, n = 2))

}

}
