% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fusionPlot.R
\name{fusionPlot}
\alias{fusionPlot}
\title{Create new charts}
\usage{
fusionPlot(data, x, y, col = NULL, type = "column2d", numberSuffix = NULL)
}
\arguments{
\item{data}{Default dataset to use}

\item{x, y}{character name of variable}

\item{col}{character name of color variable (only available to Multiple chart)}

\item{type}{See details.}

\item{numberSuffix}{Specify the suffix for all the Y-axis values on the chart}
}
\description{
Main function to make interactive charts.
Check all charts at \url{https://www.fusioncharts.com/charts}
}
\examples{
library(fusionchartsR)

# Single
df <- data.frame(label = c("Venezuela", "Saudi", "Canada", "Russia"), value = c(290, 260,180, 115))
df \%>\%
fusionPlot(x = "label", y = "value", type = "pie2d") \%>\%
fusionTheme(theme = "fusion")

# Multiple
new.data <- data.frame(
label = rep(x = c(2012:2016), times = 2),
seriesname = c(rep("iOS App Store", 5), rep("Google Play Store", 5)),
values = c(1:10)
)

new.data \%>\%
fusionPlot(
x = "label",
y = "values",
col = "seriesname",
type = "mscolumn2d",
) \%>\%
fusionTheme(theme = "fusion")

}
