% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/future_apply.R
\name{future_apply}
\alias{future_apply}
\title{Apply Functions Over Array Margins via Futures}
\usage{
future_apply(X, MARGIN, FUN, ...)
}
\arguments{
\item{X}{an array, including a matrix.}

\item{MARGIN}{A vector giving the subscripts which the function will be
applied over. For example, for a matrix \code{1} indicates rows, \code{2} indicates
columns, \code{c(1, 2)} indicates rows and columns.
Where \code{X} has named dimnames, it can be a character vector selecting
dimension names.}

\item{FUN}{A function taking at least one argument.}

\item{\ldots}{(optional) Additional arguments passed to \code{FUN()}, except
\code{future.*} arguments, which are passed on to \code{future_lapply()} used
internally.}
}
\value{
Returns a vector or array or list of values obtained by applying a
function to margins of an array or matrix.
See \code{\link[base:apply]{base::apply()}} for details.
}
\description{
\code{future_apply()} implements \code{\link[base:apply]{base::apply()}} using future with perfect
replication of results, regardless of future backend used.
It returns a vector or array or list of values obtained by applying a
function to margins of an array or matrix.
}
\examples{
## ---------------------------------------------------------
## apply()
## ---------------------------------------------------------
X <- matrix(c(1:4, 1, 6:8), nrow = 2L)

Y0 <- apply(X, MARGIN = 1L, FUN = table)
Y1 <- future_apply(X, MARGIN = 1L, FUN = table)
print(Y1)
stopifnot(all.equal(Y1, Y0, check.attributes = FALSE)) ## FIXME

Y0 <- apply(X, MARGIN = 1L, FUN = stats::quantile)
Y1 <- future_apply(X, MARGIN = 1L, FUN = stats::quantile)
print(Y1)
stopifnot(all.equal(Y1, Y0))


## ---------------------------------------------------------
## Parallel Random Number Generation
## ---------------------------------------------------------
\donttest{
## Regardless of the future plan, the number of workers, and
## where they are, the random numbers produced are identical

X <- matrix(c(1:4, 1, 6:8), nrow = 2L)

plan(multiprocess)
Y1 <- future_apply(X, MARGIN = 1L, FUN = sample, future.seed = 0xBEEF)
print(Y1)

plan(sequential)
Y2 <- future_apply(X, MARGIN = 1L, FUN = sample, future.seed = 0xBEEF)
print(Y2)

stopifnot(all.equal(Y1, Y2))
}
}
\author{
The implementations of \code{future_apply()} is adopted from the source code
of the corresponding base \R function, which is licensed under GPL (>= 2)
with 'The R Core Team' as the copyright holder.
}
