% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/future.batchtools-package.R
\docType{package}
\name{future.batchtools}
\alias{future.batchtools}
\alias{future.batchtools-package}
\title{future.batchtools: A Future for batchtools}
\description{
The \pkg{future.batchtools} package implements the Future API
on top of \pkg{batchtools} such that futures can be resolved
on for instance high-performance compute (HPC) clusters via
job schedulers.
The Future API is defined by the \pkg{future} package.
}
\details{
To use batchtools futures, load \pkg{future.batchtools}, and
select the type of future you wish to use via
\code{\link[future:plan]{plan}()}.
}
\examples{
\donttest{
plan(batchtools_local)
demo("mandelbrot", package = "future", ask = FALSE)
}

## Use local batchtools futures
plan(batchtools_local)

## A global variable
a <- 1

v \%<-\% {
  b <- 3
  c <- 2
  a * b * c
}

print(v)
}
