% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Future-class.R
\name{getExpression}
\alias{getExpression}
\alias{getExpression.Future}
\title{Inject code for the next type of future to use for nested futures}
\usage{
getExpression(future, ...)
}
\arguments{
\item{future}{Current future.}

\item{...}{Not used.}
}
\value{
A future expression with code injected to set what
type of future to use for nested futures, iff any.
}
\description{
Inject code for the next type of future to use for nested futures
}
\details{
If no next future strategy is specified, the default is to
use \link{eager} futures.  This conservative approach protects
against spawning off recursive futures by mistake, especially
\link{multicore} and \link{multisession} ones.
The default will also set \code{options(mc.cores=0L)}, which
means that no \emph{additional} R processes may be spawned off
by functions such as \code{\link[parallel:mclapply]{mclapply}()}
and friends (*).

Currently it is not possible to specify what type of nested
futures to be used, meaning the above default will always be
used.
See \href{https://github.com/HenrikBengtsson/future/issues/37}{Issue #37}
for plans on adding support for custom nested future types.

(*) Note that using \code{mc.cores=0} will unfortunately cause
    \code{mclapply()} and friends to generate an error saying
    "'mc.cores' must be >= 1".  Ideally those functions should
    fall back to using the non-multicore alternative in this
    case, e.g. \code{mclapply(...)} => \code{lapply(...)}.
    See \url{https://github.com/HenrikBengtsson/Wishlist-for-R/issues/7}
    for a discussion on this.
}
\keyword{internal}

