% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multisession.R
\name{multisession}
\alias{multisession}
\title{Create a multisession future whose value will be resolved asynchronously in a parallel \R session}
\usage{
multisession(
  expr,
  envir = parent.frame(),
  substitute = TRUE,
  lazy = FALSE,
  seed = NULL,
  globals = TRUE,
  persistent = FALSE,
  workers = availableCores(),
  gc = FALSE,
  earlySignal = FALSE,
  label = NULL,
  ...
)
}
\arguments{
\item{expr}{An \R \link[base]{expression}.}

\item{envir}{The \link{environment} from where global objects should be
identified.}

\item{substitute}{If TRUE, argument \code{expr} is
\code{\link[base]{substitute}()}:ed, otherwise not.}

\item{lazy}{If FALSE (default), the future is resolved
eagerly (starting immediately), otherwise not.}

\item{seed}{(optional) If TRUE, the random seed, that is, the state of the
random number generator (RNG) will be set such that statistically sound
random numbers are produced (also during parallelization).
If FALSE (default), it is assumed that the future expression does neither
need nor use random numbers generation.
To use a fixed random seed, specify a L'Ecuyer-CMRG seed (seven integer)
or a regular RNG seed (a single integer).
Furthermore, if FALSE, then the future will be monitored to make sure it
does not use random numbers.  If it does and depending on the value of
option \code{\link[=future.options]{future.rng.onMisuse}}, the check is
ignored, an informative warning, or error will be produced.
If \code{seed} is NULL, then the effect is as with \code{seed = FALSE}
but without the RNG check being performed.}

\item{globals}{(optional) a logical, a character vector, or a named list
to control how globals are handled.
For details, see section 'Globals used by future expressions'
in the help for \code{\link[=future]{future()}}.}

\item{persistent}{If FALSE, the evaluation environment is cleared
from objects prior to the evaluation of the future.}

\item{workers}{A positive numeric scalar or a function specifying the
maximum number of parallel futures that can be active at the same time
before blocking.
If a function, it is called without arguments \emph{when the future
is created} and its value is used to configure the workers.
The function should return a numeric scalar.}

\item{gc}{If TRUE, the garbage collector run (in the process that
evaluated the future) only after the value of the future is collected.
Exactly when the values are collected may depend on various factors such
as number of free workers and whether \code{earlySignal} is TRUE (more
frequently) or FALSE (less frequently).
\emph{Some types of futures ignore this argument.}}

\item{earlySignal}{Specified whether conditions should be signaled as soon
as possible or not.}

\item{label}{An optional character string label attached to the future.}

\item{...}{Additional named elements passed to \code{\link[=Future]{Future()}}.}
}
\value{
A \link{MultisessionFuture}.
If \code{workers == 1}, then all processing using done in the
current/main \R session and we therefore fall back to using
a lazy future.
}
\description{
A multisession future is a future that uses multisession evaluation,
which means that its \emph{value is computed and resolved in
parallel in another \R session}.
}
\details{
The background \R sessions (the "workers") are created using
\code{\link[=makeClusterPSOCK]{makeClusterPSOCK()}}.

The \code{multisession()} function will block if all available
\R session are occupied
and will be unblocked as soon as one of the already running
multisession futures is resolved.  For the total number of
\R sessions available including the current/main \R process, see
\code{\link[=availableCores]{availableCores()}}.

A multisession future is a special type of cluster future.

The preferred way to create an multisession future is not to call
this function directly, but to register it via
\code{\link{plan}(multisession)} such that it becomes the default
mechanism for all futures.  After this \code{\link[=future]{future()}}
and \code{\link{\%<-\%}} will create \emph{multisession futures}.
}
\examples{
\donttest{

## Use multisession futures
plan(multisession)

## A global variable
a <- 0

## Create future (explicitly)
f <- future({
  b <- 3
  c <- 2
  a * b * c
})

## A multisession future is evaluated in a separate R session.
## Changing the value of a global variable will not affect
## the result of the future.
a <- 7
print(a)

v <- value(f)
print(v)
stopifnot(v == 0)

## Explicitly close multisession workers by switching plan
plan(sequential)
}
}
\seealso{
For processing in multiple forked \R sessions, see
\link{multicore} futures.
For multicore processing with fallback to multisession where
the former is not supported, see \link{multiprocess} futures.

Use \code{\link[=availableCores]{availableCores()}} to see the total number of
cores that are available for the current \R session.
}
