% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exampleApplyFunctions.R
\name{average_mean_temp}
\alias{average_mean_temp}
\title{Calculate average temperature of heat waves}
\usage{
average_mean_temp(hw_datafr)
}
\arguments{
\item{hw_datafr}{A dataframe of heat waves and their characteristics, as
created by \code{\link{gen_hw_set}}}
}
\value{
A numeric value with the average temperature (degrees Fahrenheit)
   during all heat waves for a dataset of heat waves, as generated by
   \code{\link{gen_hw_set}}. This value is the mean of the average
   temperature of each heat wave, not the average temperature across all
   heat wave days (to calculate that, you would need to calculate a weighted
   mean, weighted by the number of days in each heat wave).
}
\description{
This function takes a dataframe of heat waves, as created by
\code{\link{gen_hw_set}}, and calculates the average of the daily
temperature during each heat wave across all heat waves in the dataframe.
}
\note{
This function is an example of a function that can be created and
   used to explore heat waves using the \code{\link{apply_all_models}}
   function.
}
\examples{
data(hw_datafr)
average_mean_temp(hw_datafr)

}

