% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processHeatwaves.R
\name{createHwDataframe}
\alias{createHwDataframe}
\title{Characterize heat waves}
\usage{
createHwDataframe(city, threshold, heatwaves, ensembleSeries, i, global, custom)
}
\arguments{
\item{city}{A character vector with the identification of the city
being processed.}

\item{threshold}{Numeric string with threshold temperature used in
the heat wave definition, in degrees Fahrenheit.}

\item{heatwaves}{A dataframe with the following columns:
\itemize{
\item \code{date}: Date of each observation, in class "Date";
\item \code{tmpd}: Temperature in degrees Fahrenheit;
\item \code{hw}: A binary variable designating whether a day is in a
heat wave (0: not in a heat wave; 1: in a heat wave); and
\item \code{hw.number}: A numeric value, 0 if the day was not part of a
heat wave, otherwise the number of the heat wave to which the day belonged.
}
This is the format of the output of \code{\link{IDheatwaves}}.}

\item{ensembleSeries}{A list object giving the projection time series as
well as a variety of other information for a single ensemble member.
This is the output of \code{\link{processEnsemble}}.}

\item{i}{An index specifying which city is being processed. This corresponds
to the order of the cities in the \code{citycsv} file specified in
\code{\link{gen_hw_set}}.}

\item{global}{An list object created by \code{\link{gen_hw_set}} that
includes user specifications (e.g., the path to the output directory, the
path to the input climate projections, the dataframe with city
locations).}

\item{custom}{An list object created by \code{\link{gen_hw_set}} that
includes user specifications (e.g., the name of the R function to
use to identify heat waves, alternative upper and lower year boundaries
for the data used to determine threshold temperatures for the heat wave
definition, alternative upper and lower year boundaries
for the projection period of the heat wave datasets being generated).}
}
\value{
A dataframe of identified and characterized heat waves for a single
   city and single ensemble member. Each row of this dataframe represents a
   heat wave, with the following columns:
\itemize{
   \item hw.number: A sequential number identifying each heat wave in a city;
   \item mean.temp: Average daily temperature across all days in the
      heat wave, in degrees Fahrenheit;
   \item max.temp: Highest daily temperature across days in the
      heat wave, in degrees Fahrenheit;
   \item min.temp: Lowest daily temperature across days in the
      heat wave, in degrees Fahrenheit
   \item length: Number of days in the heat wave;
   \item start.date: Date of the first day of the heat wave;
   \item end.date: Date of the last day of the heat wave;
   \item start.doy: Day of the year of the first day of the heat wave
      (1 = Jan. 1, etc.);
   \item start.month: Month in which the heat wave started (1 = January,
      etc.);
   \item days.above.80: Number of days in the heat wave above 80 degrees
       Fahrenheit;
   \item days.above.85: Number of days in the heat wave above 85 degrees
       Fahrenheit;
   \item days.above.90: Number of days in the heat wave above 90 degrees
       Fahrenheit;
   \item days.above.95: Number of days in the heat wave above 90 degrees
       Fahrenheit;
   \item days.above.99th: Number of days in the heat wave above the 99th
       percentile temperature for the city, using the period specified
       by the user with the \code{referenceBoundaries} argument in
       \code{\link{gen_hw_set}} as a reference for determining these
       percentiles;
   \item days.above.99.5th: Number of days in the heat wave above the 99.5th
       percentile temperature for the city, using the period specified
       by the user with the \code{referenceBoundaries} argument in
       \code{\link{gen_hw_set}} as a reference for determining these
       percentiles;
   \item first.in.season: Whether the heat wave was the first to occur in its
       calendar year (Note: this characteristic is likely not useful in
       southern hemisphere studies.);
   \item threshold.temp: The temperature used as the threshold for the
       heat wave definition in the city;
   \item mean.temp.quantile: The percentile of the average daily mean
       temperature during the heat wave compared to the city's year-round
       temperature distribution, based on the temperatures for the city
       during the period specified by the \code{referenceBoundaries}
       argument in \code{\link{gen_hw_set}};
   \item max.temp.quantile: The percentile of the highest daily mean
       temperature during the heat wave compared to the city's year-round
       temperature distribution;
   \item min.temp.quantile: The percentile of the lowest daily mean
       temperature during the heat wave compared to the city's year-round
       temperature distribution;
   \item mean.temp.1: The city's average year-round temperature, based
       on the temperatures for the city during the period specified by
       the \code{referenceBoundaries} argument in
       \code{\link{gen_hw_set}};
   \item mean.summer.temp: The city's average May--September
       temperature, based on the temperatures for the city during the
       period specified by the \code{referenceBoundaries} argument
       in \code{\link{gen_hw_set}}; and
   \item city: The identifier for the city, as given in the file
       specified in the \code{citycsv} argument of
       \code{\link{gen_hw_set}}.
}
}
\description{
This function takes a dataframe with identified heat waves and returns
a dataframe that lists and characterizes all of the heat waves. If no
heat waves were identified in a city, it returns a data frame with the
same columns but no observations, to allow the empty dataframe to be
joined without error to the dataframes for cities that do have heat
waves under the definition.
}
\note{
When calculating relative characteristics of heat waves, like the
relative value of the heat wave's mean temperature, this function uses a
time series from the date ranges specified by the user using the
\code{referenceBoundaries} option in \code{\link{gen_hw_set}}. By
default, these references are based on projection data from 2070 to
2079.
}

