% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tanaka.R
\name{tanaka}
\alias{tanaka}
\title{Fuzzy Linear Regression using Tanaka et al.'s Method}
\usage{
tanaka(x, y, h = 0)
}
\arguments{
\item{x}{matrix of \emph{n} independent variable observations. The first column is
related to the intercept, so it consists of ones. Missing values not allowed.}

\item{y}{two column matrix of dependent variable values and the respective spread. 
Method assumes symmetric triangular fuzzy input, so the second spread (if present)  
is ignored. Missing values not allowed.}

\item{h}{a scalar value in interval \code{[0,1]}, specifying the h-level.}
}
\value{
Returns a \code{fuzzylm} object that includes the model coefficients, limits
  for data predictions from the model and the input data.
}
\description{
The function calculates fuzzy regression coeficients using method by Tanaka et al.
(1989) using a possibilistic fuzzy estimator. Specifically, the \code{min} problem is 
implemented in this function.
}
\details{
The function input expects the response in form of a symmetric fuzzy
   number and the predictors as crisp numbers. The prediction returns 
   symmetric triangular fuzzy number coefficients. 
   The h-level is a degree of fitting chosen by the decision maker.
}
\note{
Preferred use is through the \code{\link{fuzzylm}} wrapper function with argument
   \code{method = "tanaka"}.
}
\examples{
data(fuzzydat)
fuzzylm(y ~ x, fuzzydat$tan, "tan", , , "yl", "yr")
}
\references{
Tanaka H., Hayashi I. and Watada J. (1989) Possibilistic linear 
   regression analysis for fuzzy data. \emph{European Journal of Operational 
    Research} 40: 389-396.
}
\seealso{
\code{\link{fuzzylm}}
}
\keyword{fuzzy}
