% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plr.R
\name{tanaka}
\alias{tanaka}
\title{Fuzzy Linear Regression Using the Possibilistic Linear Regression Method}
\usage{
tanaka(x, y, h = 0)
}
\arguments{
\item{x}{matrix of \emph{n} independent variable observations. The first column is
related to the intercept, so it consists of ones. Missing values not allowed.}

\item{y}{two column matrix of dependent variable values and the respective spread. 
Method assumes symmetric triangular fuzzy input, so the second spread (if present)  
is ignored. Missing values not allowed.}

\item{h}{a scalar value in interval \code{[0,1]}, specifying the h-level.}
}
\value{
Returns a \code{fuzzylm} object that includes the model coefficients, limits
  for data predictions from the model and the input data.
}
\description{
The function calculates fuzzy regression coeficients using the possibilistic linear
regression method (PLR) developed by Tanaka et al. (1989). Specifically, the 
\code{min} problem is implemented in this function.
}
\details{
The function input expects the response in form of a symmetric fuzzy
   number and the predictors as crisp numbers. The prediction returns 
   symmetric triangular fuzzy number coefficients. 
   The h-level is a degree of fitting chosen by the decision maker.
}
\references{
Tanaka H., Hayashi I. and Watada J. (1989) Possibilistic linear 
   regression analysis for fuzzy data. \emph{European Journal of Operational 
    Research} 40: 389-396.
}
\seealso{
\code{\link{fuzzylm}}
}
