% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plugins.R
\name{grid_line}
\alias{grid_line}
\title{Configure Grid Line Plugin}
\usage{
grid_line(
  key = "grid-line",
  border = TRUE,
  borderLineWidth = 1,
  borderStroke = "#eee",
  borderStyle = "solid",
  follow = FALSE,
  lineWidth = 1,
  size = 20,
  stroke = "#eee",
  ...
)
}
\arguments{
\item{key}{Unique identifier for the plugin (string, default: NULL).}

\item{border}{Whether to display the border (boolean, default: TRUE).}

\item{borderLineWidth}{Border line width (number, default: 1).}

\item{borderStroke}{Border color (string, default: "#eee").}

\item{borderStyle}{Border style (string, default: "solid").}

\item{follow}{Whether the grid follows canvas movements (boolean or list, default: FALSE).}

\item{lineWidth}{Grid line width (number or string, default: 1).}

\item{size}{Grid unit size in pixels (number, default: 20).}

\item{stroke}{Grid line color (string, default: "#eee").}

\item{...}{Extra parameters.
See \url{https://g6.antv.antgroup.com/en/manual/plugin/grid-line}.}
}
\value{
A list with the configuration settings for the grid-line plugin.
}
\description{
Creates a configuration object for the grid-line plugin in G6.
This plugin adds a background grid to the graph canvas.
}
\examples{
# Basic configuration
config <- grid_line()

# Custom configuration
config <- grid_line(
  key = "my-grid",
  border = TRUE,
  borderLineWidth = 2,
  borderStroke = "#ccc",
  borderStyle = "dashed",
  follow = list(
    translate = TRUE,
    zoom = FALSE
  ),
  lineWidth = 0.5,
  size = 30,
  stroke = "#e0e0e0"
)
}
