/*
 * Decompiled with CFR 0.152.
 */
package org.mutoss.gui.graph;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.mutoss.gui.graph.ControlMGraph;
import org.mutoss.gui.graph.Edge;
import org.mutoss.gui.graph.NetzListe;

public class UpdateEdge
extends JDialog
implements ActionListener {
    JTextField tf;
    JButton jb = new JButton("Update Edge");
    JButton jbDelete = new JButton("Remove Edge");
    Edge edge;
    NetzListe netzListe;
    ControlMGraph control;

    public UpdateEdge(Edge edge, NetzListe netzListe, ControlMGraph control) {
        super((Frame)null, "Updating Edge from node " + edge.von.name + " to " + edge.nach.name);
        this.control = control;
        this.edge = edge;
        this.netzListe = netzListe;
        String cols = "5dlu, fill:pref:grow, 5dlu, fill:pref:grow, 5dlu";
        String rows = "5dlu, pref, 5dlu, pref, 5dlu";
        FormLayout layout = new FormLayout(cols, rows);
        this.getContentPane().setLayout((LayoutManager)layout);
        CellConstraints cc = new CellConstraints();
        this.getContentPane().add((Component)new JLabel("Weight for edge:"), cc.xy(2, 2));
        String text = "" + edge.w;
        if (text.equals("NaN")) {
            text = "\u03b5";
        }
        this.tf = new JTextField(text);
        this.tf.addActionListener(this);
        this.getContentPane().add((Component)this.tf, cc.xy(4, 2));
        this.jbDelete.addActionListener(this);
        this.getContentPane().add((Component)this.jbDelete, cc.xy(2, 4));
        this.jb.addActionListener(this);
        this.getContentPane().add((Component)this.jb, cc.xy(4, 4));
        this.pack();
        this.setLocation(300, 300);
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        Double w = 0.0;
        if (e.getSource() != this.jbDelete) {
            try {
                w = Double.parseDouble(this.tf.getText());
            }
            catch (NumberFormatException ve) {
                w = Double.NaN;
            }
        }
        if (w == 0.0) {
            this.control.getDataTable().getModel().setValueAt(0, this.netzListe.getKnoten().indexOf(this.edge.von), this.netzListe.getKnoten().indexOf(this.edge.nach));
            this.netzListe.removeEdge(this.edge);
        } else {
            this.edge.setW(w);
            this.control.getDataTable().getModel().setValueAt(w, this.netzListe.getKnoten().indexOf(this.edge.von), this.netzListe.getKnoten().indexOf(this.edge.nach));
        }
        this.netzListe.repaint();
        this.dispose();
    }
}

