/*
 * Decompiled with CFR 0.152.
 */
package org.mutoss.gui.datatable;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mutoss.gui.datatable.DataTableModel;
import org.mutoss.gui.graph.EdgeWeight;

public class EpsilonTableCellRenderer
extends DefaultTableCellRenderer {
    private static final Log logger = LogFactory.getLog(EpsilonTableCellRenderer.class);

    public void setValue(Object value) {
        this.setText(value.toString());
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        DataTableModel model = (DataTableModel)table.getModel();
        double sum = 0.0;
        for (int i = 0; i < model.getColumnCount(); ++i) {
            EdgeWeight ew = model.getValueAt(row, i);
            Double d = 0.0;
            try {
                d = ew.getWeight(null)[0];
            }
            catch (Exception e) {
                // empty catch block
            }
            if (d > 1.0001 || d < 0.0) {
                sum = 1000.0;
            }
            sum += d >= 0.0 && d <= 1.0 ? d : 0.0;
        }
        DefaultTableCellRenderer dtcr = new DefaultTableCellRenderer();
        JLabel label = (JLabel)dtcr.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
        label.setText(value.toString());
        if (sum > 1.0001) {
            label.setForeground(Color.RED);
            label.setBackground(Color.ORANGE);
        } else {
            label.setForeground(null);
            label.setBackground(null);
        }
        if (row == col) {
            label.setForeground(Color.LIGHT_GRAY);
        }
        return label;
    }
}

