/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.graph;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.af.gMCP.gui.RControl;
import org.af.gMCP.gui.graph.GraphView;
import org.af.gMCP.gui.graph.NetList;
import org.af.gMCP.gui.graph.Node;

public class UpdateNode
extends JDialog
implements ActionListener {
    JTextField tf;
    JTextField tfname;
    JButton jb = new JButton("Update Node");
    JButton jbDeleteNode = new JButton("Delete Node");
    Node node;
    NetList netzListe;
    GraphView gv;

    public UpdateNode(Node node, GraphView gv) {
        super(gv.parent, "Updating Node " + node.getName(), true);
        this.node = node;
        this.gv = gv;
        this.netzListe = gv.getNL();
        String cols = "5dlu, fill:pref:grow, 5dlu, fill:pref:grow, 5dlu";
        String rows = "5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu";
        FormLayout layout = new FormLayout(cols, rows);
        this.getContentPane().setLayout((LayoutManager)layout);
        CellConstraints cc = new CellConstraints();
        int row = 2;
        this.getContentPane().add((Component)new JLabel("Weight for node " + node.getName()), cc.xy(2, row));
        this.tf = new JTextField("", 7);
        this.tf.setText("" + RControl.getFraction(node.getWeight()));
        this.tf.addActionListener(this);
        this.getContentPane().add((Component)this.tf, cc.xy(4, row));
        this.getContentPane().add((Component)new JLabel("New name"), cc.xy(2, row += 2));
        this.tfname = new JTextField();
        this.tfname.addActionListener(this);
        this.tfname.setText(node.getName());
        this.getContentPane().add((Component)this.tfname, cc.xy(4, row));
        this.jbDeleteNode.addActionListener(this);
        this.getContentPane().add((Component)this.jbDeleteNode, cc.xy(2, row += 2));
        this.jb.addActionListener(this);
        this.getContentPane().add((Component)this.jb, cc.xy(4, row));
        this.pack();
        this.setLocation(300, 300);
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.jbDeleteNode)) {
            this.netzListe.removeNode(this.node);
            this.dispose();
            return;
        }
        Double w = 0.0;
        try {
            w = RControl.getR().eval(this.tf.getText().replace(",", ".")).asRNumeric().getData()[0];
            this.tf.setBackground(Color.WHITE);
        }
        catch (Exception nfe) {
            this.tf.setBackground(Color.RED);
            JOptionPane.showMessageDialog(this, "The expression \"" + this.tf.getText() + "\" is not a valid number.", "Not a valid number", 0);
        }
        this.node.setWeight(w, null);
        int which = this.netzListe.whichNode(this.tfname.getText());
        if (which == -1 || this.netzListe.getNodes().get(which) == this.node) {
            this.gv.renameNode(this.node, this.tfname.getText());
            this.dispose();
        } else {
            JOptionPane.showMessageDialog(this, "There is already a node with name \"" + this.tfname.getText() + "\"", "Node name already in use", 0);
        }
        this.netzListe.repaint();
    }
}

