/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.config;

import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.af.gMCP.config.GeneralConfig;
import org.af.gMCP.config.JavaConfig;
import org.af.gMCP.config.PlotConfig;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Configuration {
    protected static Log logger = LogFactory.getLog(Configuration.class);
    protected Preferences prefs = Preferences.userRoot();
    protected static Configuration instance = null;
    private final String keyPrefix = "gMCP.";
    public static final String NOTFOUND = "___NOT_FOUND___";

    protected Configuration() {
    }

    public static Configuration getInstance() {
        if (instance == null) {
            instance = new Configuration();
        }
        return instance;
    }

    public void setClassProperty(Class c, String key, String value) {
        String cn = c.getName().substring(c.getName().lastIndexOf(46));
        this.setProperty("gMCP." + cn + "." + key, value);
    }

    public String getClassProperty(Class c, String key) {
        return this.getClassProperty(c, key, NOTFOUND);
    }

    public String getClassProperty(Class c, String key, String def) {
        String cn = c.getName().substring(c.getName().lastIndexOf(46));
        return this.getProperty("gMCP." + cn + "." + key, def);
    }

    protected String getProperty(String prop, String def) {
        return this.prefs.get("gMCP." + prop, def);
    }

    protected String getProperty(String prop) {
        String s = this.getProperty(prop, NOTFOUND);
        if (s.equals(NOTFOUND)) {
            throw new RuntimeException("Property required but not set: " + prop);
        }
        return s;
    }

    public void setProperty(String key, String val) {
        this.prefs.put("gMCP." + key, val);
    }

    public GeneralConfig getGeneralConfig() {
        return new GeneralConfig(this);
    }

    public PlotConfig getPlotConfig() {
        return new PlotConfig(this);
    }

    public JavaConfig getJavaConfig() {
        return new JavaConfig(this);
    }

    public String getConfigurationForDebugPurposes() {
        String s = "";
        s = s + "gMCP.\n";
        try {
            for (String key : this.prefs.keys()) {
                if (!key.startsWith("gMCP.")) continue;
                String val = this.prefs.get(key, "__NOT FOUND__");
                key = key.substring("gMCP.".length());
                s = s + key + " : " + val + "\n";
            }
        }
        catch (BackingStoreException e) {
            logger.error((Object)("Error printing configuration:\n" + e.getMessage()), (Throwable)e);
        }
        return s;
    }

    public void clearConfiguration() {
        try {
            for (String key : this.prefs.keys()) {
                if (!key.startsWith("gMCP.") || key.equals("gMCP.NumberOfStarts")) continue;
                this.prefs.remove(key);
            }
        }
        catch (BackingStoreException e) {
            logger.error((Object)("Error clearing configuration:\n" + e.getMessage()), (Throwable)e);
        }
    }
}

