/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.graph;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import org.af.gMCP.gui.RControl;
import org.af.gMCP.gui.dialogs.ColorChooseDialog;
import org.af.gMCP.gui.graph.GraphView;
import org.af.gMCP.gui.graph.NetList;
import org.af.gMCP.gui.graph.Node;
import org.apache.commons.lang.ArrayUtils;

public class UpdateNode
extends JDialog
implements ActionListener {
    List<JTextField> tfList = new Vector<JTextField>();
    JTextField tfname;
    JButton jb = new JButton("Update Node");
    JButton jbDeleteNode = new JButton("Delete Node");
    Node node;
    NetList netzListe;
    GraphView gv;
    JTabbedPane tabbedPane = new JTabbedPane();
    JSpinner spinner;
    JButton jbColor = new JButton("Choose Color");
    JLabel colorLabel = new JLabel("     ");

    public UpdateNode(Node node, GraphView gv) {
        super(gv.parent, "Updating Node " + node.getName(), true);
        this.node = node;
        this.gv = gv;
        this.netzListe = gv.getNL();
        String cols = "5dlu, fill:pref:grow, 5dlu, fill:pref:grow, 5dlu";
        String rows = "5dlu, fill:pref:grow, 5dlu, pref, 5dlu";
        this.spinner = new JSpinner(new SpinnerNumberModel(node.getRadius(), 1, 100, 1));
        FormLayout layout = new FormLayout(cols, rows);
        this.getContentPane().setLayout((LayoutManager)layout);
        CellConstraints cc = new CellConstraints();
        this.tabbedPane.addTab("Weights & Names", this.getMainPanel());
        this.tabbedPane.addTab("Further Attributes", this.getSubPanel());
        this.getContentPane().add((Component)this.tabbedPane, cc.xyw(1, 2, 5));
        int row = 4;
        this.jbDeleteNode.addActionListener(this);
        this.getContentPane().add((Component)this.jbDeleteNode, cc.xy(2, row));
        this.jb.addActionListener(this);
        this.getContentPane().add((Component)this.jb, cc.xy(4, row));
        this.pack();
        this.setSize(Math.max(this.getSize().width, 450), this.getSize().height);
        this.setLocation(300, 300);
        this.setVisible(true);
    }

    protected JPanel getMainPanel() {
        JPanel panel = new JPanel();
        String cols = "5dlu, fill:pref:grow, 5dlu, fill:pref:grow, 5dlu";
        String rows = "5dlu, pref, 5dlu, pref, 5dlu";
        for (double w : this.node.getWeight()) {
            rows = rows + ", pref, 5dlu";
        }
        FormLayout layout = new FormLayout(cols, rows);
        panel.setLayout((LayoutManager)layout);
        CellConstraints cc = new CellConstraints();
        int row = 2;
        for (double w : this.node.getWeight()) {
            panel.add((Component)new JLabel("Weight for node " + this.node.getName()), cc.xy(2, row));
            JTextField tf = new JTextField("", 7);
            tf.setText("" + RControl.getFraction(w));
            tf.addActionListener(this);
            this.tfList.add(tf);
            panel.add((Component)tf, cc.xy(4, row));
            row += 2;
        }
        panel.add((Component)new JLabel("New name"), cc.xy(2, row));
        this.tfname = new JTextField();
        this.tfname.addActionListener(this);
        this.tfname.setText(this.node.getName());
        panel.add((Component)this.tfname, cc.xy(4, row));
        return panel;
    }

    protected JPanel getSubPanel() {
        JPanel panel = new JPanel();
        String cols = "5dlu, fill:pref:grow, 5dlu, fill:pref:grow, 5dlu, fill:pref:grow, 5dlu";
        String rows = "5dlu, pref, 5dlu, pref, 5dlu";
        FormLayout layout = new FormLayout(cols, rows);
        panel.setLayout((LayoutManager)layout);
        CellConstraints cc = new CellConstraints();
        int row = 2;
        panel.add((Component)new JLabel("Color:"), cc.xy(2, row));
        this.colorLabel.setOpaque(true);
        this.colorLabel.setBackground(this.node.getColor());
        panel.add((Component)this.colorLabel, cc.xy(4, row));
        this.jbColor.addActionListener(this);
        panel.add((Component)this.jbColor, cc.xy(6, row));
        panel.add((Component)new JLabel("Radius (for all nodes):"), cc.xy(2, row += 2));
        panel.add((Component)this.spinner, cc.xy(4, row));
        return panel;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.jbColor) {
            ColorChooseDialog ccd = new ColorChooseDialog(this);
            this.node.setColor(ccd.getColor());
            this.colorLabel.setBackground(this.node.getColor());
            return;
        }
        if (e.getSource().equals(this.jbDeleteNode)) {
            this.netzListe.removeNode(this.node);
            this.dispose();
            return;
        }
        Vector<Double> wList = new Vector<Double>();
        for (JTextField tf : this.tfList) {
            try {
                double w = RControl.getR().eval(tf.getText().replace(",", ".")).asRNumeric().getData()[0];
                tf.setBackground(Color.WHITE);
                wList.add(w);
            }
            catch (Exception nfe) {
                tf.setBackground(Color.RED);
                JOptionPane.showMessageDialog(this, "The expression \"" + tf.getText() + "\" is not a valid number.", "Not a valid number", 0);
                return;
            }
        }
        this.node.setWeight(ArrayUtils.toPrimitive((Double[])wList.toArray(new Double[0])), null);
        this.gv.getNL().setRadius(Integer.parseInt(this.spinner.getModel().getValue().toString()));
        int which = this.netzListe.whichNode(this.tfname.getText());
        if (which == -1 || this.netzListe.getNodes().get(which) == this.node) {
            this.gv.renameNode(this.node, this.tfname.getText());
            this.dispose();
        } else {
            JOptionPane.showMessageDialog(this, "There is already a node with name \"" + this.tfname.getText() + "\"", "Node name already in use", 0);
        }
        this.netzListe.repaint();
    }
}

