% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/startGUIs.R
\name{corMatWizard}
\alias{corMatWizard}
\title{Graphical User Interface for the creation of correlation matrices}
\usage{
corMatWizard(n, matrix, names, envir = globalenv())
}
\arguments{
\item{n}{Square root of the dimension of the quadratic \eqn{n\times n}{nxn}-Matrix.}

\item{matrix}{Variable name of matrix of dimension \eqn{n\times n}{nxn} to start with.}

\item{names}{Row and column names. (Default will be H1,H2,\ldots,Hn.)}

\item{envir}{Environment where the object \var{matrix} is located and/or it
should be saved (default is the global environment).}
}
\value{
The function itself returns NULL.  But with the dialog a symmetric
matrix of dimension \eqn{n\times n}{nxn} can be created or edited that will
be available in R under the specified variable name after saving.
}
\description{
Starts a graphical user interface for the correlation matrices.
}
\examples{
\dontrun{
corMatWizard(5) # is equivalent to
corMatWizard(matrix=diag(5))
corMatWizard(names=c("H1", "H2", "H3", "E1", "E2"))
C <- cor(matrix(rnorm(100),10), matrix(rnorm(100),10))
corMatWizard(matrix="C") # or
corMatWizard(matrix=C) 
}

}
\author{
Kornelius Rohmeyer \email{rohmeyer@small-projects.de}
}
\keyword{graphs}
\keyword{misc}
