/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.graph;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.af.gMCP.gui.RControl;
import org.af.gMCP.gui.graph.Node;
import org.af.gMCP.gui.graph.NodeListener;
import org.af.gMCP.gui.graph.PView;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PPanel
implements ActionListener,
KeyListener,
NodeListener,
FocusListener {
    private static final Log logger = LogFactory.getLog(PPanel.class);
    double p = 0.0;
    List<Double> w;
    String name;
    JLabel label;
    private List<JTextField> wTFList = new Vector<JTextField>();
    private JTextField pTF;
    JButton jbReject;
    Node node;
    PView pview;
    Boolean rejected = false;
    DecimalFormat format = new DecimalFormat("#.######");
    static boolean testing;

    public Vector<Component> getComponent() {
        Vector<Component> v = new Vector<Component>();
        v.add(this.label);
        for (JTextField wTF : this.wTFList) {
            v.add(wTF);
        }
        v.add(this.pTF);
        v.add(this.jbReject);
        return v;
    }

    public PPanel(Node node, PView pview) {
        node.addNodeListener(this);
        this.name = node.getName();
        this.w = node.getWeight();
        this.node = node;
        this.pview = pview;
        this.label = new JLabel(this.name);
        for (Double wd : this.w) {
            JTextField wTF = new JTextField(RControl.getFraction(wd), 7);
            wTF.addActionListener(this);
            wTF.addFocusListener(this);
            wTF.addKeyListener(this);
            this.wTFList.add(wTF);
        }
        this.pTF = new JTextField(this.format.format(this.p), 7);
        this.pTF.addActionListener(this);
        this.pTF.addKeyListener(this);
        this.jbReject = new JButton("Reject and pass \u03b1");
        this.jbReject.setEnabled(false);
        this.jbReject.addActionListener(this);
        if (node.isRejected()) {
            this.reject();
        } else {
            this.updateMe(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.jbReject) {
            this.node.reject();
        } else {
            this.updateMe(false);
        }
    }

    @Override
    public void reject() {
        for (JTextField wTF : this.wTFList) {
            wTF.setEnabled(false);
        }
        this.pTF.setEnabled(false);
        this.jbReject.setEnabled(false);
        this.label.setText(this.label.getText() + " rejected!");
        this.label.setForeground(new Color(0, 100, 0));
        this.rejected = true;
        this.pview.recalculate();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.keyTyped(e);
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.keyTyped(e);
    }

    @Override
    public void keyTyped(KeyEvent e) {
        try {
            this.p = Double.parseDouble(this.pTF.getText().replace(",", "."));
            this.pTF.setBackground(Color.WHITE);
        }
        catch (NumberFormatException nfe) {
            this.pTF.setBackground(Color.RED);
        }
        this.w = new Vector<Double>();
        for (JTextField wTF : this.wTFList) {
            try {
                if (wTF.getText().length() != 0) {
                    double tempw = RControl.getR().eval(wTF.getText().replace(",", ".")).asRNumeric().getData()[0];
                    if (!Double.isInfinite(tempw) && !Double.isNaN(tempw)) {
                        wTF.setBackground(Color.WHITE);
                        this.w.add(tempw);
                        continue;
                    }
                    wTF.setBackground(Color.RED);
                    return;
                }
                wTF.setBackground(Color.RED);
                return;
            }
            catch (Exception nfe) {
                wTF.setBackground(Color.RED);
                return;
            }
        }
        this.node.setWeight(ArrayUtils.toPrimitive((Double[])this.w.toArray(new Double[0])), this);
        this.updateMe(false);
    }

    void updateMe(boolean setText) {
        if (setText) {
            this.pTF.setText(this.format.format(this.p).replace(",", "."));
        }
        if (testing) {
            this.pTF.setEditable(false);
        } else {
            this.pTF.setEditable(true);
        }
        for (int i = 0; i < this.wTFList.size(); ++i) {
            JTextField wTF = this.wTFList.get(i);
            if (!setText) continue;
            wTF.setText(this.getWString().get(i));
        }
        double sumW = 0.0;
        if (this.w.size() == 1) {
            sumW = this.w.get(0);
        } else {
            for (int k = 0; k < this.w.size(); ++k) {
                try {
                    sumW += this.w.get(k) * Double.parseDouble(this.pview.entangledWeights.get(k).getText());
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        try {
            if (this.p <= sumW * this.pview.getTotalAlpha(false)) {
                this.node.setRejectable(true);
                this.pTF.setBackground(new Color(50, 255, 50));
                if (testing) {
                    this.jbReject.setEnabled(!this.node.isRejected());
                } else {
                    this.jbReject.setEnabled(false);
                }
            } else {
                this.node.setRejectable(false);
                this.pTF.setBackground(Color.WHITE);
                this.jbReject.setEnabled(false);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (testing) {
            this.pTF.setEditable(false);
        } else {
            this.pTF.setEditable(true);
        }
        this.pview.updateLabels();
    }

    @Override
    public void updated(Node node) {
        this.name = node.getName();
        this.w = node.getWeight();
        this.updateMe(true);
    }

    private Vector<String> getWString() {
        Vector<String> result = new Vector<String>();
        for (double wd : this.w) {
            if (testing) {
                result.add(this.format.format(wd).replace(",", "."));
                continue;
            }
            result.add(RControl.getFraction(wd));
        }
        return result;
    }

    public double getP() {
        return this.p;
    }

    public void setP(double p) {
        this.p = p;
        this.updateMe(true);
    }

    public static void setTesting(boolean b) {
        testing = b;
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (this.wTFList.get(0).isEditable()) {
            this.keyTyped(null);
            for (int i = 0; i < this.wTFList.size(); ++i) {
                JTextField wTF = this.wTFList.get(i);
                if (e.getSource() != wTF || testing) continue;
                wTF.setText(RControl.getFraction(this.w.get(i)));
            }
            this.updateMe(true);
        }
    }

    public void addEntangledLayer() {
        JTextField wTF = new JTextField("0", 7);
        wTF.addActionListener(this);
        wTF.addFocusListener(this);
        wTF.addKeyListener(this);
        this.wTFList.add(wTF);
        this.w.add(0.0);
    }

    public void removeEntangledLayer(int layer) {
        this.wTFList.get(layer).removeActionListener(this);
        this.wTFList.remove(layer);
    }
}

