/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.options;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.af.commons.widgets.validate.ValidationException;
import org.af.gMCP.config.Configuration;
import org.af.gMCP.gui.options.OptionsPanel;

public class MiscPanel
extends OptionsPanel {
    private JCheckBox checkOnlineForUpdate;
    private JCheckBox exportTransparent;
    private JCheckBox unanchorEdges;
    private JCheckBox focusEqualsEdit;
    private JCheckBox enableNewFeatures;
    private JCheckBox showRCode;
    private Configuration conf;

    public MiscPanel(Configuration conf) {
        this.conf = conf;
        this.makeComponents();
        this.doTheLayout();
    }

    private void makeComponents() {
        this.checkOnlineForUpdate = new JCheckBox("Check online for updates");
        this.checkOnlineForUpdate.setSelected(this.conf.getGeneralConfig().checkOnline());
        this.checkOnlineForUpdate.setToolTipText("<html>On start-up gMCP can check automatically whether a new version<br>\nof gMCP is available. Only your version of R (like 2.13.1),<br>\nthe version of gMCP (like 0.7-5) and a random number<br>\n(to distinguish different requests) are transmitted.</html>");
        this.exportTransparent = new JCheckBox("Export images with transparent background");
        this.exportTransparent.setSelected(this.conf.getGeneralConfig().exportTransparent());
        this.exportTransparent.setToolTipText("<html>If checked the background of exported PNG graphics will be transparent.<br>\nOtherwise the graphs are displayed on a white background.</html>");
        this.unanchorEdges = new JCheckBox("Edge weights should adjust their position, whenever a node is dragged");
        this.unanchorEdges.setSelected(this.conf.getGeneralConfig().getUnAnchor());
        this.unanchorEdges.setToolTipText("<html>If selected the edges will always repositioned whenever a node is dragged.<br>\nOtherwise only newly added eges behave that way and edges that have<br>\nbeen dragged themselves are considered \"anchored\" and will stay<br>\nwith the edge weight label at the same position.</html>");
        this.focusEqualsEdit = new JCheckBox("Automatically enter the editing mode, whenever a table cell gets the focus");
        this.focusEqualsEdit.setSelected(this.conf.getGeneralConfig().focusEqualsEdit());
        this.focusEqualsEdit.setToolTipText("<html>People are used to different behaviour of tables (mostly<br>depending on which spreadsheet applications they use regularly). If this<br>option is set to true it is easy to change the values of the cells but<br>navigating with arrow keys is hard since in the editing mode the right and<br>left key will move the cursor only in the currently selected cell.</html>");
        this.enableNewFeatures = new JCheckBox("Enable highly experimental features");
        this.enableNewFeatures.setSelected(this.conf.getGeneralConfig().experimentalFeatures());
        this.enableNewFeatures.setToolTipText("<html>The gMCP GUI often contains new features that are not that well tested.<br>If you want to use or take a look at them, activate this option.<br>But be prepared that things might go wrong.</html>");
        this.showRCode = new JCheckBox("Show R code to reproduce results in R");
        this.showRCode.setSelected(this.conf.getGeneralConfig().showRCode());
        this.showRCode.setToolTipText("<html>After performing a test in the GUI the result dialog does not only show the pure<br>results, but also R code to reproduce these results in R. If you are not interested in this feature,<br>you can disable it here.</html>");
    }

    private void doTheLayout() {
        JPanel p1 = new JPanel();
        String cols = "pref, 5dlu, fill:pref:grow";
        String rows = "pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref";
        FormLayout layout = new FormLayout(cols, rows);
        p1.setLayout((LayoutManager)layout);
        CellConstraints cc = new CellConstraints();
        int row = 1;
        p1.add((Component)this.checkOnlineForUpdate, cc.xyw(1, row, 3));
        p1.add((Component)this.exportTransparent, cc.xyw(1, row += 2, 3));
        p1.add((Component)this.unanchorEdges, cc.xyw(1, row += 2, 3));
        p1.add((Component)this.focusEqualsEdit, cc.xyw(1, row += 2, 3));
        p1.add((Component)this.enableNewFeatures, cc.xyw(1, row += 2, 3));
        p1.add((Component)this.showRCode, cc.xyw(1, row += 2, 3));
        row += 2;
        this.add(p1);
    }

    public void setProperties() throws ValidationException {
        this.conf.getGeneralConfig().setCheckOnline(this.checkOnlineForUpdate.isSelected());
        this.conf.getGeneralConfig().setExportTransparent(this.exportTransparent.isSelected());
        this.conf.getGeneralConfig().setUnAnchor(this.unanchorEdges.isSelected());
        this.conf.getGeneralConfig().setFocusEqualsEdit(this.focusEqualsEdit.isSelected());
        this.conf.getGeneralConfig().setExperimental(this.enableNewFeatures.isSelected());
        this.conf.getGeneralConfig().setShowRCode(this.showRCode.isSelected());
    }
}

