% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{loadView}
\alias{loadView}
\title{Help function to load the view angle for the RGL 3D plot from a file or matrix}
\usage{
loadView(fname = "view.RData", v = NULL, clear = TRUE,
  close = FALSE, zoom = 1, ...)
}
\arguments{
\item{fname}{The file name of the view.}

\item{v}{The view matrix.}

\item{clear}{Call \link{clear3d}.}

\item{close}{Call \link{rgl.close}.}

\item{zoom}{Zoom level.}

\item{...}{Additional parameters passed to \link{view3d}.}
}
\description{
Help function to load the view angle for the RGL 3D plot from a file or matrix
}
\examples{
view <- matrix( c(-0.412063330411911, -0.228006735444069, 0.882166087627411, 0,
0.910147845745087, -0.0574885793030262, 0.410274744033813, 0, -0.042830865830183,
0.97196090221405, 0.231208890676498, 0, 0, 0, 0, 1), nc = 4)

loadView(v = view)
A <- matrix( c(3, 2, 5, 2, 1, 1, 1, 1, 3, 5, 2, 4), nc = 3, byrow = TRUE)
b <- c(55, 26, 30, 57)
obj <- c(20, 10, 15)
plotPolytope(A, b, plotOptimum = TRUE, obj = obj, labels = "coord")

# Try to modify the angle in the RGL window
saveView(print = TRUE)  # get the viewangle to insert into R code
}
\author{
Lars Relund \email{lars@relund.dk}
}
