% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{grain_predict}
\alias{grain_predict}
\alias{predict.grain}
\title{Make predictions from a probabilistic network}
\usage{
\method{predict}{grain}(
  object,
  response,
  predictors = setdiff(names(newdata), response),
  newdata,
  type = "class",
  ...
)
}
\arguments{
\item{object}{A grain object}

\item{response}{A vector of response variables to make predictions
on}

\item{predictors}{A vector of predictor variables to make
predictions from.  Defaults to all variables that are note
responses.}

\item{newdata}{A data frame}

\item{type}{If "class", the most probable class is returned; if
"distribution" the conditional distrubtion is returned.}

\item{...}{Not used}
}
\value{
A list with components \item{pred}{A list with the
predictions} \item{pFinding}{A vector with the probability of
the finding (evidence) on which the prediction is based}
}
\description{
Makes predictions (either as the most likely state or
as the conditional distributions) of variables conditional on
finding (evidence) on other variables in an independence
network.
}
\examples{
data(chest_cpt)
data(chestSim500)

chest.bn <- grain(compileCPT(chest_cpt))
nd <- chestSim500[1:4]

predict(chest.bn, response="bronc", newdata=nd)
predict(chest.bn, response="bronc", newdata=nd, type="distribution")

}
\references{
Søren Højsgaard (2012). Graphical Independence Networks
with the gRain Package for R. Journal of Statistical Software,
46(10), 1-26.  \url{http://www.jstatsoft.org/v46/i10/}.
}
\seealso{
\code{\link{grain}}
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\keyword{models}
