% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/propagate.R
\name{grain_propagate}
\alias{grain_propagate}
\alias{propagate.grain}
\alias{propagateLS}
\alias{propagateLS__}
\alias{compute_p_evidence}
\title{Propagate a graphical independence network (a Bayesian network)}
\usage{
\method{propagate}{grain}(object, details = object$details, engine = "cpp", ...)

propagateLS(cq_pot_list, rip, initialize = TRUE, details = 0)

compute_p_evidence(object, details = object$details, engine = "cpp", ...)
}
\arguments{
\item{object}{A grain object}

\item{details}{For debugging info}

\item{engine}{Either "R" or "cpp"; "cpp" is the default and the
fastest.}

\item{...}{Currently not used}

\item{cq_pot_list}{List of clique potentials}

\item{rip}{A rip ordering}

\item{initialize}{Always true.}
}
\value{
A compiled and propagated grain object.
}
\description{
Propagation refers to calibrating the cliques of the
junction tree so that the clique potentials are consistent on
their intersections; refer to the reference below for details.
}
\details{
The \code{propagate} method invokes \code{propagateLS}
which is a pure R implementation of the Lauritzen-Spiegelhalter
algorithm. The c++ based version is several times faster than
the purely R based version.
}
\examples{

example("grain")

## Uncompiled and unpropageted network:
bn0  <- grain(chest_cpt, compile=FALSE)
bn0
## Compiled but unpropageted network:
bn1  <- compile(bn0, propagate=FALSE)
## Compiled and propagated network
bn2  <- propagate(bn1)
bn2
## Default is that networks are compiled but not propagated at creation time:
bn3  <- grain(chest_cpt) 
bn3 
}
\references{
Søren Højsgaard (2012). Graphical Independence Networks
with the gRain Package for R. Journal of Statistical Software,
46(10), 1-26.  \url{https://www.jstatsoft.org/v46/i10/}.
}
\seealso{
\code{\link{grain}}, \code{\link[gRbase]{compile}}
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\keyword{models}
\keyword{utilities}
