% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cptable_special.R
\name{logical}
\alias{logical}
\alias{booltab}
\alias{andtable}
\alias{ortable}
\alias{andtab}
\alias{ortab}
\title{Conditional probability tables based on logical dependencies}
\usage{
booltab(vpa, levels = c(TRUE, FALSE), op = `&`)

andtab(vpa, levels = c(TRUE, FALSE))

ortab(vpa, levels = c(TRUE, FALSE))

andtable(vpa, levels = c(TRUE, FALSE))

ortable(vpa, levels = c(TRUE, FALSE))
}
\arguments{
\item{vpa}{Node and two parents; as a formula or a character
vector.}

\item{levels}{The levels (or rather labels) of v, see 'examples'
below.}

\item{op}{A logical operator.}
}
\value{
An array.
}
\description{
Generate conditional probability tables based on the
logical expressions AND and OR.
}
\details{
Regarding the form of the argument \code{vpa}: To specify
\eqn{P(a|b,c)} one may write \code{~a|b+c} or \code{~a+b+c} or
\code{~a|b:c} or \code{~a:b:c} or \code{c("a","b","c")}.
Internally, the last form is used. Notice that the \code{+} and
\code{:} operator are used as separators only. The order of the
variables is important so \code{+} and \code{:} DO NOT commute.
}
\note{
\code{andtable} and \code{ortable} are aliases for
\code{andtab} and \code{ortab} and are kept for backward
compatibility.
}
\examples{

## Logical OR:

## A variable v is TRUE if either of its parents pa1 and pa2 are TRUE:
ortab( c("v", "pa1", "pa2") ) \%>\% ftable(row.vars="v")
## TRUE and FALSE can be recoded to e.g. yes and no:
ortab( c("v", "pa1", "pa2"), levels=c("yes", "no") ) \%>\% ftable(row.vars="v")

## Logical AND:

## Same story here:
andtab(c("v", "pa1", "pa2") ) \%>\% ftable(row.vars="v")
andtab(c("v", "pa1", "pa2"), levels=c("yes", "no") ) \%>\% ftable(row.vars="v")

## Combined approach

booltab(c("v", "pa1", "pa2"), op=`&`) \%>\% ftable(row.vars="v") ## AND
booltab(c("v", "pa1", "pa2"), op=`|`) \%>\% ftable(row.vars="v") ## OR

booltab(~v + pa1 + pa2, op=`&`) \%>\% ftable(row.vars="v") ## AND
booltab(~v + pa1 + pa2, op=`|`) \%>\% ftable(row.vars="v") ## OR

}
\references{
Søren Højsgaard (2012). Graphical Independence Networks
with the gRain Package for R. Journal of Statistical Software,
46(10), 1-26.  \url{https://www.jstatsoft.org/v46/i10/}.
}
\seealso{
\code{\link{cptable}}
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\keyword{utilities}
